# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.structured_result_data_id import StructuredResultDataId
from lusid.models.virtual_document_row import VirtualDocumentRow

class VirtualDocument(BaseModel):
    """
    Virtual document consists of (potentially several) upserted documents.                The documents get parsed according to the provided data map on upsert, the collection of resulting values in  aggregated in a virtual document  # noqa: E501
    """
    document_id: Optional[StructuredResultDataId] = Field(default=None, alias="documentId")
    data: Optional[List[VirtualDocumentRow]] = Field(default=None, description="The data inside the document")
    __properties = ["documentId", "data"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VirtualDocument:
        """Create an instance of VirtualDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of document_id
        if self.document_id:
            _dict['documentId'] = self.document_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item in self.data:
                if _item:
                    _items.append(_item.to_dict())
            _dict['data'] = _items
        # set to None if data (nullable) is None
        # and __fields_set__ contains the field
        if self.data is None and "data" in self.__fields_set__:
            _dict['data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VirtualDocument:
        """Create an instance of VirtualDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VirtualDocument.parse_obj(obj)

        _obj = VirtualDocument.parse_obj({
            "document_id": StructuredResultDataId.from_dict(obj.get("documentId")) if obj.get("documentId") is not None else None,
            "data": [VirtualDocumentRow.from_dict(_item) for _item in obj.get("data")] if obj.get("data") is not None else None
        })
        return _obj

VirtualDocument.update_forward_refs()
