# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.weighted_instrument import WeightedInstrument

class WeightedInstruments(BaseModel):
    """
    Class that models a set of instruments of which each has some quantity and can be identified by a unique label.  # noqa: E501
    """
    instruments: List[WeightedInstrument] = Field(description="The instruments that are held in the set.")
    __properties = ["instruments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WeightedInstruments:
        """Create an instance of WeightedInstruments from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in instruments (list)
        _items = []
        if self.instruments:
            for _item in self.instruments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['instruments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WeightedInstruments:
        """Create an instance of WeightedInstruments from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WeightedInstruments.parse_obj(obj)

        _obj = WeightedInstruments.parse_obj({
            "instruments": [WeightedInstrument.from_dict(_item) for _item in obj.get("instruments")] if obj.get("instruments") is not None else None
        })
        return _obj

WeightedInstruments.update_forward_refs()
