# mypy-boto3-sns

[![PyPI - mypy-boto3-sns](https://img.shields.io/pypi/v/mypy-boto3-sns.svg?color=blue)](https://pypi.org/project/mypy-boto3-sns)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sns.svg?color=blue)](https://pypi.org/project/mypy-boto3-sns)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SNS 1.16.46](https://boto3.amazonaws.com/v1/documentation/api/1.16.46/reference/services/sns.html#SNS) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sns](#mypy-boto3-sns)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `SNS` service.

```bash
python -m pip install boto3-stubs[sns]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sns]` in your environment: `python -m pip install 'boto3-stubs[sns]'`

Both type checking and auto-complete should work for `SNS` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[sns]` in your environment: `python -m pip install 'boto3-stubs[sns]'`

Both type checking and auto-complete should work for `SNS` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sns]` in your environment: `python -m pip install 'boto3-stubs[sns]'`
- Run `mypy` as usual

Type checking should work for `SNS` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sns]` in your environment: `python -m pip install 'boto3-stubs[sns]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SNS` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`SNSClient` provides annotations for `boto3.client("sns")`.

```python
import boto3

from mypy_boto3_sns import SNSClient

client: SNSClient = boto3.client("sns")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SNSClient = session.client("sns")
```

### Paginators annotations

`mypy_boto3_sns.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_sns import SNSClient
from mypy_boto3_sns.paginator import (
    ListEndpointsByPlatformApplicationPaginator,
    ListPhoneNumbersOptedOutPaginator,
    ListPlatformApplicationsPaginator,
    ListSubscriptionsByTopicPaginator,
    ListSubscriptionsPaginator,
    ListTopicsPaginator,
)

client: SNSClient = boto3.client("sns")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_endpoints_by_platform_application_paginator: ListEndpointsByPlatformApplicationPaginator = client.get_paginator("list_endpoints_by_platform_application")
list_phone_numbers_opted_out_paginator: ListPhoneNumbersOptedOutPaginator = client.get_paginator("list_phone_numbers_opted_out")
list_platform_applications_paginator: ListPlatformApplicationsPaginator = client.get_paginator("list_platform_applications")
list_subscriptions_paginator: ListSubscriptionsPaginator = client.get_paginator("list_subscriptions")
list_subscriptions_by_topic_paginator: ListSubscriptionsByTopicPaginator = client.get_paginator("list_subscriptions_by_topic")
list_topics_paginator: ListTopicsPaginator = client.get_paginator("list_topics")
```




### Service Resource annotations

`SNSServiceResource` provides annotations for `boto3.resource("sns")`.

```python
from mypy_boto3_sns import SNSServiceResource

resource: SNSServiceResource = boto3.resource("sns")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: SNSServiceResource = session.resource("sns")
```


### Other resources annotations

`mypy_boto3_sns.service_resource` module contains type annotations for all resources.

```python
from mypy_boto3_sns import SNSServiceResource
from mypy_boto3_sns.service_resource import (
    PlatformApplication,
    PlatformEndpoint,
    Subscription,
    Topic,
)

resource: SNSServiceResource = boto3.resource("sns")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_platform_application: PlatformApplication = resource.PlatformApplication(...)
my_platform_endpoint: PlatformEndpoint = resource.PlatformEndpoint(...)
my_subscription: Subscription = resource.Subscription(...)
my_topic: Topic = resource.Topic(...)
```



### Collections annotations

`mypy_boto3_sns.service_resource` module contains type annotations
for all `SNSServiceResource` collections.

```python
from mypy_boto3_sns import SNSServiceResource
from mypy_boto3_sns.service_resource import (
    ServiceResourcePlatformApplicationsCollection,
    ServiceResourceSubscriptionsCollection,
    ServiceResourceTopicsCollection,
)

resource: SNSServiceResource = boto3.resource("sns")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
platform_applications: sns_resources.ServiceResourcePlatformApplicationsCollection = resource.platform_applications
subscriptions: sns_resources.ServiceResourceSubscriptionsCollection = resource.subscriptions
topics: sns_resources.ServiceResourceTopicsCollection = resource.topics
```




### Typed dictionations

`mypy_boto3_sns.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_sns.type_defs import (
    CheckIfPhoneNumberIsOptedOutResponseTypeDef,
    ConfirmSubscriptionResponseTypeDef,
    CreateEndpointResponseTypeDef,
    CreatePlatformApplicationResponseTypeDef,
    CreateTopicResponseTypeDef,
    EndpointTypeDef,
    GetEndpointAttributesResponseTypeDef,
    GetPlatformApplicationAttributesResponseTypeDef,
    GetSMSAttributesResponseTypeDef,
    GetSubscriptionAttributesResponseTypeDef,
    GetTopicAttributesResponseTypeDef,
    ListEndpointsByPlatformApplicationResponseTypeDef,
    ListPhoneNumbersOptedOutResponseTypeDef,
    ListPlatformApplicationsResponseTypeDef,
    ListSubscriptionsByTopicResponseTypeDef,
    ListSubscriptionsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTopicsResponseTypeDef,
    MessageAttributeValueTypeDef,
    PaginatorConfigTypeDef,
    PlatformApplicationTypeDef,
    PublishResponseTypeDef,
    SubscribeResponseTypeDef,
    SubscriptionTypeDef,
    TagTypeDef,
    TopicTypeDef,
)

def get_structure() -> EndpointTypeDef:
    return {
      ...
    }
```
