<div align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/user-attachments/assets/1d8b44f1-1999-4cfb-8744-32871056c253">
    <img alt="kuva-space-logo" src="https://github.com/user-attachments/assets/d8f47cc8-1491-4d0c-a8cf-318ea7e0afdc" width="50%">
  </picture>
</div>

# Kuva Geometry

The `kuva-geometry` project contains various class definitions and utility functions related 
to imaging and Earth geometry. These help in processing Kuva Space products and to provide 
additional commonly used tools.

Currently, the main use is for calculating the satellite camera rays on the Earth to get 
footprints of the imaged area.

# Installation

```bash
pip install kuva-geometry
``` 

This package is also included when installing the `kuva-reader`.

### Requirements

`Python 3.10` to `3.13`, preferably within a virtual environment

# Contributing

Please follow the guidelines in [CONTRIBUTING.md](https://github.com/KuvaSpace/kuva-data-processing/blob/main/CONTRIBUTING.md).

Also, please follow our [Code of Conduct](https://github.com/KuvaSpace/kuva-data-processing/blob/main/CODE_OF_CONDUCT.md)
while discussing in the issues and pull requests.

# Contact information

For questions or support, please open an issue. If you have been given a support contact, 
feel free to send them an email explaining your issue.

# License

The `kuva-reader` project software is under the [MIT license](https://github.com/KuvaSpace/kuva-data-processing/blob/main/LICENSE.md).

# Status of unit tests

[![Unit tests for kuva-geometry](https://github.com/KuvaSpace/kuva-data-processing/actions/workflows/test-kuva-geometry.yml/badge.svg)](https://github.com/KuvaSpace/kuva-data-processing/actions/workflows/test-kuva-geometry.yml)