"""
AST Predicates - Interface definitions for matching Python AST nodes.

This module provides the core interfaces and base classes for building
declarative matchers for Python's ast module.
"""

from __future__ import annotations

from .core import extract as extract
from .core import find_all as find_all
from .core import find_first as find_first
from .core import matches as matches
from .matchers import AllOf as AllOf
from .matchers import AtLeastN as AtLeastN
from .matchers import AtMostN as AtMostN
from .matchers import DoNotCare as DoNotCare
from .matchers import Matcher as Matcher
from .matchers import MatchIfTrue as MatchIfTrue
from .matchers import OneOf as OneOf
from .nodes import Add as Add
from .nodes import Alias as Alias
from .nodes import And as And
from .nodes import Assert as Assert
from .nodes import Assign as Assign
from .nodes import AsyncFor as AsyncFor
from .nodes import AsyncFunctionDef as AsyncFunctionDef
from .nodes import AsyncWith as AsyncWith
from .nodes import Attribute as Attribute
from .nodes import AugAssign as AugAssign
from .nodes import Await as Await
from .nodes import BinOp as BinOp
from .nodes import BitAnd as BitAnd
from .nodes import BitOr as BitOr
from .nodes import BitXor as BitXor
from .nodes import BoolOp as BoolOp
from .nodes import Break as Break
from .nodes import Call as Call
from .nodes import ClassDef as ClassDef
from .nodes import Compare as Compare
from .nodes import Constant as Constant
from .nodes import Continue as Continue
from .nodes import Delete as Delete
from .nodes import Dict as Dict
from .nodes import DictComp as DictComp
from .nodes import Div as Div
from .nodes import Eq as Eq
from .nodes import Expr as Expr
from .nodes import FloorDiv as FloorDiv
from .nodes import For as For
from .nodes import FormattedValue as FormattedValue
from .nodes import FunctionDef as FunctionDef
from .nodes import GeneratorExp as GeneratorExp
from .nodes import Global as Global
from .nodes import Gt as Gt
from .nodes import GtE as GtE
from .nodes import If as If
from .nodes import IfExp as IfExp
from .nodes import Import as Import
from .nodes import ImportFrom as ImportFrom
from .nodes import Invert as Invert
from .nodes import Is as Is
from .nodes import IsNot as IsNot
from .nodes import JoinedStr as JoinedStr
from .nodes import Keyword as Keyword
from .nodes import Lambda as Lambda
from .nodes import List as List
from .nodes import ListComp as ListComp
from .nodes import LShift as LShift
from .nodes import Lt as Lt
from .nodes import LtE as LtE
from .nodes import MatMult as MatMult
from .nodes import Mod as Mod
from .nodes import Module as Module
from .nodes import Mult as Mult
from .nodes import Name as Name
from .nodes import NodeMatcher as NodeMatcher
from .nodes import Nonlocal as Nonlocal
from .nodes import Not as Not
from .nodes import NotEq as NotEq
from .nodes import NotIn as NotIn
from .nodes import Or as Or
from .nodes import Pass as Pass
from .nodes import Pow as Pow
from .nodes import Raise as Raise
from .nodes import Return as Return
from .nodes import RShift as RShift
from .nodes import Set as Set
from .nodes import SetComp as SetComp
from .nodes import Slice as Slice
from .nodes import Starred as Starred
from .nodes import Sub as Sub
from .nodes import Subscript as Subscript
from .nodes import Try as Try
from .nodes import Tuple as Tuple
from .nodes import UAdd as UAdd
from .nodes import UnaryOp as UnaryOp
from .nodes import USub as USub
from .nodes import While as While
from .nodes import Yield as Yield
from .nodes import YieldFrom as YieldFrom
