from .exceptions import TuringDBException as TuringDBException
from .s3 import S3Client as S3Client
from _typeshed import Incomplete
from typing import Literal

class TuringDB:
    DEFAULT_HEADERS: Incomplete
    host: Incomplete
    def __init__(self, instance_id: str = '', auth_token: str = '', host: str = 'https://engines.turingdb.ai/sdk', timeout: int | None = None) -> None: ...
    def try_reach(self, timeout: int = 5): ...
    def warmup(self, timeout: int = 5): ...
    def list_available_graphs(self) -> list[str]: ...
    def list_loaded_graphs(self) -> list[str]: ...
    def is_graph_loaded(self) -> bool: ...
    def load_graph(self, graph_name: str, raise_if_loaded: bool = True): ...
    def create_graph(self, graph_name: str): ...
    def query(self, query: str): ...
    def set_commit(self, commit: str): ...
    def set_change(self, change: int | str): ...
    def checkout(self, change: int | Literal['main'] = 'main', commit: str = 'HEAD'): ...
    def new_change(self) -> int: ...
    def set_graph(self, graph_name: str): ...
    def get_graph(self) -> str: ...
    def s3_connect(self, bucket_name: str, access_key: str | None = None, secret_key: str | None = None, region: str | None = None, use_scratch: bool = True): ...
    def transfer(self, src: str, dst: str): ...
    def get_query_exec_time(self) -> float | None: ...
    def get_total_exec_time(self) -> float | None: ...
    @property
    def current_graph(self) -> str: ...
    @property
    def current_commit(self) -> str: ...
    @property
    def current_change(self) -> str: ...
