# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.action_service_execution_type_filter import ActionServiceExecutionTypeFilter
from zitadel_client.models.action_service_in_conditions_filter import ActionServiceInConditionsFilter
from zitadel_client.models.action_service_target_filter import ActionServiceTargetFilter
from typing import Optional, Set
from typing_extensions import Self

class ActionServiceExecutionSearchFilter(BaseModel):
    """
    ActionServiceExecutionSearchFilter
    """ # noqa: E501
    execution_type_filter: Optional[ActionServiceExecutionTypeFilter] = Field(default=None, alias="executionTypeFilter")
    in_conditions_filter: Optional[ActionServiceInConditionsFilter] = Field(default=None, alias="inConditionsFilter")
    target_filter: Optional[ActionServiceTargetFilter] = Field(default=None, alias="targetFilter")
    __properties: ClassVar[List[str]] = ["executionTypeFilter", "inConditionsFilter", "targetFilter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActionServiceExecutionSearchFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of execution_type_filter
        if self.execution_type_filter:
            _dict['executionTypeFilter'] = self.execution_type_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of in_conditions_filter
        if self.in_conditions_filter:
            _dict['inConditionsFilter'] = self.in_conditions_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of target_filter
        if self.target_filter:
            _dict['targetFilter'] = self.target_filter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActionServiceExecutionSearchFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "executionTypeFilter": ActionServiceExecutionTypeFilter.from_dict(obj["executionTypeFilter"]) if obj.get("executionTypeFilter") is not None else None,
            "inConditionsFilter": ActionServiceInConditionsFilter.from_dict(obj["inConditionsFilter"]) if obj.get("inConditionsFilter") is not None else None,
            "targetFilter": ActionServiceTargetFilter.from_dict(obj["targetFilter"]) if obj.get("targetFilter") is not None else None
        })
        return _obj


