# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class BetaActionServicePaginationResponse(BaseModel):
    """
    BetaActionServicePaginationResponse
    """ # noqa: E501
    total_result: Optional[Any] = Field(default=None, description="Absolute number of objects matching the query, regardless of applied limit.", alias="totalResult")
    applied_limit: Optional[Any] = Field(default=None, description="Applied limit from query, defines maximum amount of objects per request, to compare if all objects are returned.", alias="appliedLimit")
    __properties: ClassVar[List[str]] = ["totalResult", "appliedLimit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaActionServicePaginationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if total_result (nullable) is None
        # and model_fields_set contains the field
        if self.total_result is None and "total_result" in self.model_fields_set:
            _dict['totalResult'] = None

        # set to None if applied_limit (nullable) is None
        # and model_fields_set contains the field
        if self.applied_limit is None and "applied_limit" in self.model_fields_set:
            _dict['appliedLimit'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaActionServicePaginationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalResult": obj.get("totalResult"),
            "appliedLimit": obj.get("appliedLimit")
        })
        return _obj


