# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_app_service_app_state import BetaAppServiceAppState
from zitadel_client.models.beta_app_service_application_name_query import BetaAppServiceApplicationNameQuery
from typing import Optional, Set
from typing_extensions import Self

class BetaAppServiceApplicationSearchFilter(BaseModel):
    """
    BetaAppServiceApplicationSearchFilter
    """ # noqa: E501
    api_app_only: Optional[StrictBool] = Field(default=None, alias="apiAppOnly")
    name_filter: Optional[BetaAppServiceApplicationNameQuery] = Field(default=None, alias="nameFilter")
    oidc_app_only: Optional[StrictBool] = Field(default=None, alias="oidcAppOnly")
    saml_app_only: Optional[StrictBool] = Field(default=None, alias="samlAppOnly")
    state_filter: Optional[BetaAppServiceAppState] = Field(default=None, alias="stateFilter")
    __properties: ClassVar[List[str]] = ["apiAppOnly", "nameFilter", "oidcAppOnly", "samlAppOnly", "stateFilter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaAppServiceApplicationSearchFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of name_filter
        if self.name_filter:
            _dict['nameFilter'] = self.name_filter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaAppServiceApplicationSearchFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apiAppOnly": obj.get("apiAppOnly"),
            "nameFilter": BetaAppServiceApplicationNameQuery.from_dict(obj["nameFilter"]) if obj.get("nameFilter") is not None else None,
            "oidcAppOnly": obj.get("oidcAppOnly"),
            "samlAppOnly": obj.get("samlAppOnly"),
            "stateFilter": obj.get("stateFilter")
        })
        return _obj


