# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_app_service_create_api_application_request import BetaAppServiceCreateAPIApplicationRequest
from zitadel_client.models.beta_app_service_create_oidc_application_request import BetaAppServiceCreateOIDCApplicationRequest
from zitadel_client.models.beta_app_service_create_saml_application_request import BetaAppServiceCreateSAMLApplicationRequest
from typing import Optional, Set
from typing_extensions import Self

class BetaAppServiceCreateApplicationRequest(BaseModel):
    """
    BetaAppServiceCreateApplicationRequest
    """ # noqa: E501
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    api_request: Optional[BetaAppServiceCreateAPIApplicationRequest] = Field(default=None, alias="apiRequest")
    oidc_request: Optional[BetaAppServiceCreateOIDCApplicationRequest] = Field(default=None, alias="oidcRequest")
    saml_request: Optional[BetaAppServiceCreateSAMLApplicationRequest] = Field(default=None, alias="samlRequest")
    __properties: ClassVar[List[str]] = ["projectId", "id", "name", "apiRequest", "oidcRequest", "samlRequest"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaAppServiceCreateApplicationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of api_request
        if self.api_request:
            _dict['apiRequest'] = self.api_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oidc_request
        if self.oidc_request:
            _dict['oidcRequest'] = self.oidc_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of saml_request
        if self.saml_request:
            _dict['samlRequest'] = self.saml_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaAppServiceCreateApplicationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "projectId": obj.get("projectId"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "apiRequest": BetaAppServiceCreateAPIApplicationRequest.from_dict(obj["apiRequest"]) if obj.get("apiRequest") is not None else None,
            "oidcRequest": BetaAppServiceCreateOIDCApplicationRequest.from_dict(obj["oidcRequest"]) if obj.get("oidcRequest") is not None else None,
            "samlRequest": BetaAppServiceCreateSAMLApplicationRequest.from_dict(obj["samlRequest"]) if obj.get("samlRequest") is not None else None
        })
        return _obj


