# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.beta_app_service_app_sorting import BetaAppServiceAppSorting
from zitadel_client.models.beta_app_service_application_search_filter import BetaAppServiceApplicationSearchFilter
from zitadel_client.models.beta_app_service_pagination_request import BetaAppServicePaginationRequest
from typing import Optional, Set
from typing_extensions import Self

class BetaAppServiceListApplicationsRequest(BaseModel):
    """
    BetaAppServiceListApplicationsRequest
    """ # noqa: E501
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    pagination: Optional[BetaAppServicePaginationRequest] = None
    filters: Optional[List[BetaAppServiceApplicationSearchFilter]] = Field(default=None, description="criteria the client is looking for")
    sorting_column: Optional[BetaAppServiceAppSorting] = Field(default=None, alias="sortingColumn")
    __properties: ClassVar[List[str]] = ["projectId", "pagination", "filters", "sortingColumn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaAppServiceListApplicationsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict['filters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaAppServiceListApplicationsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "projectId": obj.get("projectId"),
            "pagination": BetaAppServicePaginationRequest.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None,
            "filters": [BetaAppServiceApplicationSearchFilter.from_dict(_item) for _item in obj["filters"]] if obj.get("filters") is not None else None,
            "sortingColumn": obj.get("sortingColumn")
        })
        return _obj


