# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.beta_app_service_login_version import BetaAppServiceLoginVersion
from zitadel_client.models.beta_app_service_oidc_app_type import BetaAppServiceOIDCAppType
from zitadel_client.models.beta_app_service_oidc_auth_method_type import BetaAppServiceOIDCAuthMethodType
from zitadel_client.models.beta_app_service_oidc_grant_type import BetaAppServiceOIDCGrantType
from zitadel_client.models.beta_app_service_oidc_response_type import BetaAppServiceOIDCResponseType
from zitadel_client.models.beta_app_service_oidc_token_type import BetaAppServiceOIDCTokenType
from zitadel_client.models.beta_app_service_oidc_version import BetaAppServiceOIDCVersion
from typing import Optional, Set
from typing_extensions import Self

class BetaAppServiceUpdateOIDCApplicationConfigurationRequest(BaseModel):
    """
    BetaAppServiceUpdateOIDCApplicationConfigurationRequest
    """ # noqa: E501
    redirect_uris: Optional[List[StrictStr]] = Field(default=None, alias="redirectUris")
    response_types: Optional[List[BetaAppServiceOIDCResponseType]] = Field(default=None, alias="responseTypes")
    grant_types: Optional[List[BetaAppServiceOIDCGrantType]] = Field(default=None, alias="grantTypes")
    app_type: Optional[BetaAppServiceOIDCAppType] = Field(default=None, alias="appType")
    auth_method_type: Optional[BetaAppServiceOIDCAuthMethodType] = Field(default=None, alias="authMethodType")
    post_logout_redirect_uris: Optional[List[StrictStr]] = Field(default=None, alias="postLogoutRedirectUris")
    version: Optional[BetaAppServiceOIDCVersion] = None
    dev_mode: Optional[StrictBool] = Field(default=None, alias="devMode")
    access_token_type: Optional[BetaAppServiceOIDCTokenType] = Field(default=None, alias="accessTokenType")
    access_token_role_assertion: Optional[StrictBool] = Field(default=None, alias="accessTokenRoleAssertion")
    id_token_role_assertion: Optional[StrictBool] = Field(default=None, alias="idTokenRoleAssertion")
    id_token_userinfo_assertion: Optional[StrictBool] = Field(default=None, alias="idTokenUserinfoAssertion")
    clock_skew: Optional[StrictStr] = Field(default=None, description="A Duration represents a signed, fixed-length span of time represented  as a count of seconds and fractions of seconds at nanosecond  resolution. It is independent of any calendar and concepts like \"day\"  or \"month\". It is related to Timestamp in that the difference between  two Timestamp values is a Duration and it can be added or subtracted  from a Timestamp. Range is approximately +-10,000 years.   # Examples   Example 1: Compute Duration from two Timestamps in pseudo code.       Timestamp start = ...;      Timestamp end = ...;      Duration duration = ...;       duration.seconds = end.seconds - start.seconds;      duration.nanos = end.nanos - start.nanos;       if (duration.seconds < 0 && duration.nanos > 0) {        duration.seconds += 1;        duration.nanos -= 1000000000;      } else if (duration.seconds > 0 && duration.nanos < 0) {        duration.seconds -= 1;        duration.nanos += 1000000000;      }   Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.       Timestamp start = ...;      Duration duration = ...;      Timestamp end = ...;       end.seconds = start.seconds + duration.seconds;      end.nanos = start.nanos + duration.nanos;       if (end.nanos < 0) {        end.seconds -= 1;        end.nanos += 1000000000;      } else if (end.nanos >= 1000000000) {        end.seconds += 1;        end.nanos -= 1000000000;      }   Example 3: Compute Duration from datetime.timedelta in Python.       td = datetime.timedelta(days=3, minutes=10)      duration = Duration()      duration.FromTimedelta(td)   # JSON Mapping   In JSON format, the Duration type is encoded as a string rather than an  object, where the string ends in the suffix \"s\" (indicating seconds) and  is preceded by the number of seconds, with nanoseconds expressed as  fractional seconds. For example, 3 seconds with 0 nanoseconds should be  encoded in JSON format as \"3s\", while 3 seconds and 1 nanosecond should  be expressed in JSON format as \"3.000000001s\", and 3 seconds and 1  microsecond should be expressed in JSON format as \"3.000001s\".", alias="clockSkew")
    additional_origins: Optional[List[StrictStr]] = Field(default=None, alias="additionalOrigins")
    skip_native_app_success_page: Optional[StrictBool] = Field(default=None, alias="skipNativeAppSuccessPage")
    back_channel_logout_uri: Optional[StrictStr] = Field(default=None, alias="backChannelLogoutUri")
    login_version: Optional[BetaAppServiceLoginVersion] = Field(default=None, alias="loginVersion")
    __properties: ClassVar[List[str]] = ["redirectUris", "responseTypes", "grantTypes", "appType", "authMethodType", "postLogoutRedirectUris", "version", "devMode", "accessTokenType", "accessTokenRoleAssertion", "idTokenRoleAssertion", "idTokenUserinfoAssertion", "clockSkew", "additionalOrigins", "skipNativeAppSuccessPage", "backChannelLogoutUri", "loginVersion"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaAppServiceUpdateOIDCApplicationConfigurationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of login_version
        if self.login_version:
            _dict['loginVersion'] = self.login_version.to_dict()
        # set to None if dev_mode (nullable) is None
        # and model_fields_set contains the field
        if self.dev_mode is None and "dev_mode" in self.model_fields_set:
            _dict['devMode'] = None

        # set to None if access_token_role_assertion (nullable) is None
        # and model_fields_set contains the field
        if self.access_token_role_assertion is None and "access_token_role_assertion" in self.model_fields_set:
            _dict['accessTokenRoleAssertion'] = None

        # set to None if id_token_role_assertion (nullable) is None
        # and model_fields_set contains the field
        if self.id_token_role_assertion is None and "id_token_role_assertion" in self.model_fields_set:
            _dict['idTokenRoleAssertion'] = None

        # set to None if id_token_userinfo_assertion (nullable) is None
        # and model_fields_set contains the field
        if self.id_token_userinfo_assertion is None and "id_token_userinfo_assertion" in self.model_fields_set:
            _dict['idTokenUserinfoAssertion'] = None

        # set to None if skip_native_app_success_page (nullable) is None
        # and model_fields_set contains the field
        if self.skip_native_app_success_page is None and "skip_native_app_success_page" in self.model_fields_set:
            _dict['skipNativeAppSuccessPage'] = None

        # set to None if back_channel_logout_uri (nullable) is None
        # and model_fields_set contains the field
        if self.back_channel_logout_uri is None and "back_channel_logout_uri" in self.model_fields_set:
            _dict['backChannelLogoutUri'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaAppServiceUpdateOIDCApplicationConfigurationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "redirectUris": obj.get("redirectUris"),
            "responseTypes": obj.get("responseTypes"),
            "grantTypes": obj.get("grantTypes"),
            "appType": obj.get("appType"),
            "authMethodType": obj.get("authMethodType"),
            "postLogoutRedirectUris": obj.get("postLogoutRedirectUris"),
            "version": obj.get("version"),
            "devMode": obj.get("devMode"),
            "accessTokenType": obj.get("accessTokenType"),
            "accessTokenRoleAssertion": obj.get("accessTokenRoleAssertion"),
            "idTokenRoleAssertion": obj.get("idTokenRoleAssertion"),
            "idTokenUserinfoAssertion": obj.get("idTokenUserinfoAssertion"),
            "clockSkew": obj.get("clockSkew"),
            "additionalOrigins": obj.get("additionalOrigins"),
            "skipNativeAppSuccessPage": obj.get("skipNativeAppSuccessPage"),
            "backChannelLogoutUri": obj.get("backChannelLogoutUri"),
            "loginVersion": BetaAppServiceLoginVersion.from_dict(obj["loginVersion"]) if obj.get("loginVersion") is not None else None
        })
        return _obj


