# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_authorization_service_id_filter import BetaAuthorizationServiceIDFilter
from zitadel_client.models.beta_authorization_service_in_ids_filter import BetaAuthorizationServiceInIDsFilter
from zitadel_client.models.beta_authorization_service_project_name_query import BetaAuthorizationServiceProjectNameQuery
from zitadel_client.models.beta_authorization_service_role_key_query import BetaAuthorizationServiceRoleKeyQuery
from zitadel_client.models.beta_authorization_service_state_query import BetaAuthorizationServiceStateQuery
from zitadel_client.models.beta_authorization_service_user_display_name_query import BetaAuthorizationServiceUserDisplayNameQuery
from zitadel_client.models.beta_authorization_service_user_preferred_login_name_query import BetaAuthorizationServiceUserPreferredLoginNameQuery
from typing import Optional, Set
from typing_extensions import Self

class BetaAuthorizationServiceAuthorizationsSearchFilter(BaseModel):
    """
    BetaAuthorizationServiceAuthorizationsSearchFilter
    """ # noqa: E501
    authorization_ids: Optional[BetaAuthorizationServiceInIDsFilter] = Field(default=None, alias="authorizationIds")
    organization_id: Optional[BetaAuthorizationServiceIDFilter] = Field(default=None, alias="organizationId")
    project_grant_id: Optional[BetaAuthorizationServiceIDFilter] = Field(default=None, alias="projectGrantId")
    project_id: Optional[BetaAuthorizationServiceIDFilter] = Field(default=None, alias="projectId")
    project_name: Optional[BetaAuthorizationServiceProjectNameQuery] = Field(default=None, alias="projectName")
    role_key: Optional[BetaAuthorizationServiceRoleKeyQuery] = Field(default=None, alias="roleKey")
    state: Optional[BetaAuthorizationServiceStateQuery] = None
    user_display_name: Optional[BetaAuthorizationServiceUserDisplayNameQuery] = Field(default=None, alias="userDisplayName")
    user_id: Optional[BetaAuthorizationServiceIDFilter] = Field(default=None, alias="userId")
    user_organization_id: Optional[BetaAuthorizationServiceIDFilter] = Field(default=None, alias="userOrganizationId")
    user_preferred_login_name: Optional[BetaAuthorizationServiceUserPreferredLoginNameQuery] = Field(default=None, alias="userPreferredLoginName")
    __properties: ClassVar[List[str]] = ["authorizationIds", "organizationId", "projectGrantId", "projectId", "projectName", "roleKey", "state", "userDisplayName", "userId", "userOrganizationId", "userPreferredLoginName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaAuthorizationServiceAuthorizationsSearchFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of authorization_ids
        if self.authorization_ids:
            _dict['authorizationIds'] = self.authorization_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization_id
        if self.organization_id:
            _dict['organizationId'] = self.organization_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_grant_id
        if self.project_grant_id:
            _dict['projectGrantId'] = self.project_grant_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_id
        if self.project_id:
            _dict['projectId'] = self.project_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_name
        if self.project_name:
            _dict['projectName'] = self.project_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of role_key
        if self.role_key:
            _dict['roleKey'] = self.role_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_display_name
        if self.user_display_name:
            _dict['userDisplayName'] = self.user_display_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_id
        if self.user_id:
            _dict['userId'] = self.user_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_organization_id
        if self.user_organization_id:
            _dict['userOrganizationId'] = self.user_organization_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_preferred_login_name
        if self.user_preferred_login_name:
            _dict['userPreferredLoginName'] = self.user_preferred_login_name.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaAuthorizationServiceAuthorizationsSearchFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "authorizationIds": BetaAuthorizationServiceInIDsFilter.from_dict(obj["authorizationIds"]) if obj.get("authorizationIds") is not None else None,
            "organizationId": BetaAuthorizationServiceIDFilter.from_dict(obj["organizationId"]) if obj.get("organizationId") is not None else None,
            "projectGrantId": BetaAuthorizationServiceIDFilter.from_dict(obj["projectGrantId"]) if obj.get("projectGrantId") is not None else None,
            "projectId": BetaAuthorizationServiceIDFilter.from_dict(obj["projectId"]) if obj.get("projectId") is not None else None,
            "projectName": BetaAuthorizationServiceProjectNameQuery.from_dict(obj["projectName"]) if obj.get("projectName") is not None else None,
            "roleKey": BetaAuthorizationServiceRoleKeyQuery.from_dict(obj["roleKey"]) if obj.get("roleKey") is not None else None,
            "state": BetaAuthorizationServiceStateQuery.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "userDisplayName": BetaAuthorizationServiceUserDisplayNameQuery.from_dict(obj["userDisplayName"]) if obj.get("userDisplayName") is not None else None,
            "userId": BetaAuthorizationServiceIDFilter.from_dict(obj["userId"]) if obj.get("userId") is not None else None,
            "userOrganizationId": BetaAuthorizationServiceIDFilter.from_dict(obj["userOrganizationId"]) if obj.get("userOrganizationId") is not None else None,
            "userPreferredLoginName": BetaAuthorizationServiceUserPreferredLoginNameQuery.from_dict(obj["userPreferredLoginName"]) if obj.get("userPreferredLoginName") is not None else None
        })
        return _obj


