# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BetaAuthorizationServiceCreateAuthorizationRequest(BaseModel):
    """
    BetaAuthorizationServiceCreateAuthorizationRequest
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, description="UserID is the ID of the user who should be granted the authorization.", alias="userId")
    project_id: Optional[StrictStr] = Field(default=None, description="Project ID is the ID of the project the user should be authorized for.", alias="projectId")
    organization_id: Optional[StrictStr] = Field(default=None, description="OrganizationID is the ID of the organization on which the authorization should be created.  The organization must either own the project or have a grant for the project.  If omitted, the authorization is created on the projects organization.", alias="organizationId")
    role_keys: Optional[List[StrictStr]] = Field(default=None, description="RoleKeys are the keys of the roles the user should be granted.", alias="roleKeys")
    __properties: ClassVar[List[str]] = ["userId", "projectId", "organizationId", "roleKeys"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaAuthorizationServiceCreateAuthorizationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if organization_id (nullable) is None
        # and model_fields_set contains the field
        if self.organization_id is None and "organization_id" in self.model_fields_set:
            _dict['organizationId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaAuthorizationServiceCreateAuthorizationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "projectId": obj.get("projectId"),
            "organizationId": obj.get("organizationId"),
            "roleKeys": obj.get("roleKeys")
        })
        return _obj


