# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class BetaAuthorizationServiceUser(BaseModel):
    """
    BetaAuthorizationServiceUser
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID represents the ID of the user who was granted the authorization.")
    preferred_login_name: Optional[StrictStr] = Field(default=None, description="PreferredLoginName represents the preferred login name of the granted user.", alias="preferredLoginName")
    display_name: Optional[StrictStr] = Field(default=None, description="DisplayName represents the public display name of the granted user.", alias="displayName")
    avatar_url: Optional[StrictStr] = Field(default=None, description="AvatarURL is the URL to the user's public avatar image.", alias="avatarUrl")
    organization_id: Optional[StrictStr] = Field(default=None, description="The organization the user belong to.  This does not have to correspond with the authorizations organization.", alias="organizationId")
    __properties: ClassVar[List[str]] = ["id", "preferredLoginName", "displayName", "avatarUrl", "organizationId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaAuthorizationServiceUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaAuthorizationServiceUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "preferredLoginName": obj.get("preferredLoginName"),
            "displayName": obj.get("displayName"),
            "avatarUrl": obj.get("avatarUrl"),
            "organizationId": obj.get("organizationId")
        })
        return _obj


