# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_feature_service_details import BetaFeatureServiceDetails
from zitadel_client.models.beta_feature_service_feature_flag import BetaFeatureServiceFeatureFlag
from zitadel_client.models.beta_feature_service_improved_performance_feature_flag import BetaFeatureServiceImprovedPerformanceFeatureFlag
from typing import Optional, Set
from typing_extensions import Self

class BetaFeatureServiceGetSystemFeaturesResponse(BaseModel):
    """
    BetaFeatureServiceGetSystemFeaturesResponse
    """ # noqa: E501
    details: Optional[BetaFeatureServiceDetails] = None
    login_default_org: Optional[BetaFeatureServiceFeatureFlag] = Field(default=None, alias="loginDefaultOrg")
    user_schema: Optional[BetaFeatureServiceFeatureFlag] = Field(default=None, alias="userSchema")
    oidc_token_exchange: Optional[BetaFeatureServiceFeatureFlag] = Field(default=None, alias="oidcTokenExchange")
    improved_performance: Optional[BetaFeatureServiceImprovedPerformanceFeatureFlag] = Field(default=None, alias="improvedPerformance")
    oidc_single_v1_session_termination: Optional[BetaFeatureServiceFeatureFlag] = Field(default=None, alias="oidcSingleV1SessionTermination")
    __properties: ClassVar[List[str]] = ["details", "loginDefaultOrg", "userSchema", "oidcTokenExchange", "improvedPerformance", "oidcSingleV1SessionTermination"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaFeatureServiceGetSystemFeaturesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict['details'] = self.details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of login_default_org
        if self.login_default_org:
            _dict['loginDefaultOrg'] = self.login_default_org.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_schema
        if self.user_schema:
            _dict['userSchema'] = self.user_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oidc_token_exchange
        if self.oidc_token_exchange:
            _dict['oidcTokenExchange'] = self.oidc_token_exchange.to_dict()
        # override the default output from pydantic by calling `to_dict()` of improved_performance
        if self.improved_performance:
            _dict['improvedPerformance'] = self.improved_performance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oidc_single_v1_session_termination
        if self.oidc_single_v1_session_termination:
            _dict['oidcSingleV1SessionTermination'] = self.oidc_single_v1_session_termination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaFeatureServiceGetSystemFeaturesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "details": BetaFeatureServiceDetails.from_dict(obj["details"]) if obj.get("details") is not None else None,
            "loginDefaultOrg": BetaFeatureServiceFeatureFlag.from_dict(obj["loginDefaultOrg"]) if obj.get("loginDefaultOrg") is not None else None,
            "userSchema": BetaFeatureServiceFeatureFlag.from_dict(obj["userSchema"]) if obj.get("userSchema") is not None else None,
            "oidcTokenExchange": BetaFeatureServiceFeatureFlag.from_dict(obj["oidcTokenExchange"]) if obj.get("oidcTokenExchange") is not None else None,
            "improvedPerformance": BetaFeatureServiceImprovedPerformanceFeatureFlag.from_dict(obj["improvedPerformance"]) if obj.get("improvedPerformance") is not None else None,
            "oidcSingleV1SessionTermination": BetaFeatureServiceFeatureFlag.from_dict(obj["oidcSingleV1SessionTermination"]) if obj.get("oidcSingleV1SessionTermination") is not None else None
        })
        return _obj


