# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.beta_feature_service_improved_performance import BetaFeatureServiceImprovedPerformance
from typing import Optional, Set
from typing_extensions import Self

class BetaFeatureServiceSetSystemFeaturesRequest(BaseModel):
    """
    BetaFeatureServiceSetSystemFeaturesRequest
    """ # noqa: E501
    login_default_org: Optional[StrictBool] = Field(default=None, alias="loginDefaultOrg")
    user_schema: Optional[StrictBool] = Field(default=None, alias="userSchema")
    oidc_token_exchange: Optional[StrictBool] = Field(default=None, alias="oidcTokenExchange")
    improved_performance: Optional[List[BetaFeatureServiceImprovedPerformance]] = Field(default=None, alias="improvedPerformance")
    oidc_single_v1_session_termination: Optional[StrictBool] = Field(default=None, alias="oidcSingleV1SessionTermination")
    __properties: ClassVar[List[str]] = ["loginDefaultOrg", "userSchema", "oidcTokenExchange", "improvedPerformance", "oidcSingleV1SessionTermination"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaFeatureServiceSetSystemFeaturesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if login_default_org (nullable) is None
        # and model_fields_set contains the field
        if self.login_default_org is None and "login_default_org" in self.model_fields_set:
            _dict['loginDefaultOrg'] = None

        # set to None if user_schema (nullable) is None
        # and model_fields_set contains the field
        if self.user_schema is None and "user_schema" in self.model_fields_set:
            _dict['userSchema'] = None

        # set to None if oidc_token_exchange (nullable) is None
        # and model_fields_set contains the field
        if self.oidc_token_exchange is None and "oidc_token_exchange" in self.model_fields_set:
            _dict['oidcTokenExchange'] = None

        # set to None if oidc_single_v1_session_termination (nullable) is None
        # and model_fields_set contains the field
        if self.oidc_single_v1_session_termination is None and "oidc_single_v1_session_termination" in self.model_fields_set:
            _dict['oidcSingleV1SessionTermination'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaFeatureServiceSetSystemFeaturesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "loginDefaultOrg": obj.get("loginDefaultOrg"),
            "userSchema": obj.get("userSchema"),
            "oidcTokenExchange": obj.get("oidcTokenExchange"),
            "improvedPerformance": obj.get("improvedPerformance"),
            "oidcSingleV1SessionTermination": obj.get("oidcSingleV1SessionTermination")
        })
        return _obj


