# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.beta_instance_service_field_name import BetaInstanceServiceFieldName
from zitadel_client.models.beta_instance_service_pagination_request import BetaInstanceServicePaginationRequest
from zitadel_client.models.beta_instance_service_query import BetaInstanceServiceQuery
from typing import Optional, Set
from typing_extensions import Self

class BetaInstanceServiceListInstancesRequest(BaseModel):
    """
    BetaInstanceServiceListInstancesRequest
    """ # noqa: E501
    queries: Optional[List[BetaInstanceServiceQuery]] = Field(default=None, description="Criterias the client is looking for.")
    pagination: Optional[BetaInstanceServicePaginationRequest] = None
    sorting_column: Optional[BetaInstanceServiceFieldName] = Field(default=None, alias="sortingColumn")
    __properties: ClassVar[List[str]] = ["queries", "pagination", "sortingColumn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaInstanceServiceListInstancesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in queries (list)
        _items = []
        if self.queries:
            for _item_queries in self.queries:
                if _item_queries:
                    _items.append(_item_queries.to_dict())
            _dict['queries'] = _items
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaInstanceServiceListInstancesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "queries": [BetaInstanceServiceQuery.from_dict(_item) for _item in obj["queries"]] if obj.get("queries") is not None else None,
            "pagination": BetaInstanceServicePaginationRequest.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None,
            "sortingColumn": obj.get("sortingColumn")
        })
        return _obj


