# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_organization_service_domain_validation_type import BetaOrganizationServiceDomainValidationType
from typing import Optional, Set
from typing_extensions import Self

class BetaOrganizationServiceDomain(BaseModel):
    """
    from proto/zitadel/org.proto
    """ # noqa: E501
    organization_id: Optional[StrictStr] = Field(default=None, description="The Organization id.", alias="organizationId")
    domain_name: Optional[StrictStr] = Field(default=None, description="The domain name.", alias="domainName")
    is_verified: Optional[StrictBool] = Field(default=None, description="Defines if the domain is verified.", alias="isVerified")
    is_primary: Optional[StrictBool] = Field(default=None, description="Defines if the domain is the primary domain.", alias="isPrimary")
    validation_type: Optional[BetaOrganizationServiceDomainValidationType] = Field(default=None, alias="validationType")
    __properties: ClassVar[List[str]] = ["organizationId", "domainName", "isVerified", "isPrimary", "validationType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaOrganizationServiceDomain from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaOrganizationServiceDomain from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organizationId": obj.get("organizationId"),
            "domainName": obj.get("domainName"),
            "isVerified": obj.get("isVerified"),
            "isPrimary": obj.get("isPrimary"),
            "validationType": obj.get("validationType")
        })
        return _obj


