# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_organization_service_assigned_admin import BetaOrganizationServiceAssignedAdmin
from zitadel_client.models.beta_organization_service_created_admin import BetaOrganizationServiceCreatedAdmin
from typing import Optional, Set
from typing_extensions import Self

class BetaOrganizationServiceOrganizationAdmin(BaseModel):
    """
    BetaOrganizationServiceOrganizationAdmin
    """ # noqa: E501
    assigned_admin: Optional[BetaOrganizationServiceAssignedAdmin] = Field(default=None, alias="assignedAdmin")
    created_admin: Optional[BetaOrganizationServiceCreatedAdmin] = Field(default=None, alias="createdAdmin")
    __properties: ClassVar[List[str]] = ["assignedAdmin", "createdAdmin"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaOrganizationServiceOrganizationAdmin from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of assigned_admin
        if self.assigned_admin:
            _dict['assignedAdmin'] = self.assigned_admin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_admin
        if self.created_admin:
            _dict['createdAdmin'] = self.created_admin.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaOrganizationServiceOrganizationAdmin from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignedAdmin": BetaOrganizationServiceAssignedAdmin.from_dict(obj["assignedAdmin"]) if obj.get("assignedAdmin") is not None else None,
            "createdAdmin": BetaOrganizationServiceCreatedAdmin.from_dict(obj["createdAdmin"]) if obj.get("createdAdmin") is not None else None
        })
        return _obj


