# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_organization_service_org_domain_filter import BetaOrganizationServiceOrgDomainFilter
from zitadel_client.models.beta_organization_service_org_id_filter import BetaOrganizationServiceOrgIDFilter
from zitadel_client.models.beta_organization_service_org_name_filter import BetaOrganizationServiceOrgNameFilter
from zitadel_client.models.beta_organization_service_org_state_filter import BetaOrganizationServiceOrgStateFilter
from typing import Optional, Set
from typing_extensions import Self

class BetaOrganizationServiceOrganizationSearchFilter(BaseModel):
    """
    BetaOrganizationServiceOrganizationSearchFilter
    """ # noqa: E501
    domain_filter: Optional[BetaOrganizationServiceOrgDomainFilter] = Field(default=None, alias="domainFilter")
    id_filter: Optional[BetaOrganizationServiceOrgIDFilter] = Field(default=None, alias="idFilter")
    name_filter: Optional[BetaOrganizationServiceOrgNameFilter] = Field(default=None, alias="nameFilter")
    state_filter: Optional[BetaOrganizationServiceOrgStateFilter] = Field(default=None, alias="stateFilter")
    __properties: ClassVar[List[str]] = ["domainFilter", "idFilter", "nameFilter", "stateFilter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaOrganizationServiceOrganizationSearchFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of domain_filter
        if self.domain_filter:
            _dict['domainFilter'] = self.domain_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of id_filter
        if self.id_filter:
            _dict['idFilter'] = self.id_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of name_filter
        if self.name_filter:
            _dict['nameFilter'] = self.name_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state_filter
        if self.state_filter:
            _dict['stateFilter'] = self.state_filter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaOrganizationServiceOrganizationSearchFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "domainFilter": BetaOrganizationServiceOrgDomainFilter.from_dict(obj["domainFilter"]) if obj.get("domainFilter") is not None else None,
            "idFilter": BetaOrganizationServiceOrgIDFilter.from_dict(obj["idFilter"]) if obj.get("idFilter") is not None else None,
            "nameFilter": BetaOrganizationServiceOrgNameFilter.from_dict(obj["nameFilter"]) if obj.get("nameFilter") is not None else None,
            "stateFilter": BetaOrganizationServiceOrgStateFilter.from_dict(obj["stateFilter"]) if obj.get("stateFilter") is not None else None
        })
        return _obj


