# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_project_service_private_labeling_setting import BetaProjectServicePrivateLabelingSetting
from typing import Optional, Set
from typing_extensions import Self

class BetaProjectServiceUpdateProjectRequest(BaseModel):
    """
    BetaProjectServiceUpdateProjectRequest
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = Field(default=None, description="Name of the project.")
    project_role_assertion: Optional[StrictBool] = Field(default=None, description="Enable this setting to have role information included in the user info endpoint. It is also dependent on your application settings to include it in tokens and other types.", alias="projectRoleAssertion")
    project_role_check: Optional[StrictBool] = Field(default=None, description="When enabled ZITADEL will check if a user has a role of this project assigned when login into an application of this project.", alias="projectRoleCheck")
    has_project_check: Optional[StrictBool] = Field(default=None, description="When enabled ZITADEL will check if the organization of the user, that is trying to log in, has a grant to this project.", alias="hasProjectCheck")
    private_labeling_setting: Optional[BetaProjectServicePrivateLabelingSetting] = Field(default=None, alias="privateLabelingSetting")
    __properties: ClassVar[List[str]] = ["id", "name", "projectRoleAssertion", "projectRoleCheck", "hasProjectCheck", "privateLabelingSetting"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaProjectServiceUpdateProjectRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if project_role_assertion (nullable) is None
        # and model_fields_set contains the field
        if self.project_role_assertion is None and "project_role_assertion" in self.model_fields_set:
            _dict['projectRoleAssertion'] = None

        # set to None if project_role_check (nullable) is None
        # and model_fields_set contains the field
        if self.project_role_check is None and "project_role_check" in self.model_fields_set:
            _dict['projectRoleCheck'] = None

        # set to None if has_project_check (nullable) is None
        # and model_fields_set contains the field
        if self.has_project_check is None and "has_project_check" in self.model_fields_set:
            _dict['hasProjectCheck'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaProjectServiceUpdateProjectRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "projectRoleAssertion": obj.get("projectRoleAssertion"),
            "projectRoleCheck": obj.get("projectRoleCheck"),
            "hasProjectCheck": obj.get("hasProjectCheck"),
            "privateLabelingSetting": obj.get("privateLabelingSetting")
        })
        return _obj


