# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_session_service_intent_factor import BetaSessionServiceIntentFactor
from zitadel_client.models.beta_session_service_otp_factor import BetaSessionServiceOTPFactor
from zitadel_client.models.beta_session_service_password_factor import BetaSessionServicePasswordFactor
from zitadel_client.models.beta_session_service_totp_factor import BetaSessionServiceTOTPFactor
from zitadel_client.models.beta_session_service_user_factor import BetaSessionServiceUserFactor
from zitadel_client.models.beta_session_service_web_auth_n_factor import BetaSessionServiceWebAuthNFactor
from typing import Optional, Set
from typing_extensions import Self

class BetaSessionServiceFactors(BaseModel):
    """
    BetaSessionServiceFactors
    """ # noqa: E501
    user: Optional[BetaSessionServiceUserFactor] = None
    password: Optional[BetaSessionServicePasswordFactor] = None
    web_auth_n: Optional[BetaSessionServiceWebAuthNFactor] = Field(default=None, alias="webAuthN")
    intent: Optional[BetaSessionServiceIntentFactor] = None
    totp: Optional[BetaSessionServiceTOTPFactor] = None
    otp_sms: Optional[BetaSessionServiceOTPFactor] = Field(default=None, alias="otpSms")
    otp_email: Optional[BetaSessionServiceOTPFactor] = Field(default=None, alias="otpEmail")
    __properties: ClassVar[List[str]] = ["user", "password", "webAuthN", "intent", "totp", "otpSms", "otpEmail"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaSessionServiceFactors from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of password
        if self.password:
            _dict['password'] = self.password.to_dict()
        # override the default output from pydantic by calling `to_dict()` of web_auth_n
        if self.web_auth_n:
            _dict['webAuthN'] = self.web_auth_n.to_dict()
        # override the default output from pydantic by calling `to_dict()` of intent
        if self.intent:
            _dict['intent'] = self.intent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of totp
        if self.totp:
            _dict['totp'] = self.totp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of otp_sms
        if self.otp_sms:
            _dict['otpSms'] = self.otp_sms.to_dict()
        # override the default output from pydantic by calling `to_dict()` of otp_email
        if self.otp_email:
            _dict['otpEmail'] = self.otp_email.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaSessionServiceFactors from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user": BetaSessionServiceUserFactor.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "password": BetaSessionServicePasswordFactor.from_dict(obj["password"]) if obj.get("password") is not None else None,
            "webAuthN": BetaSessionServiceWebAuthNFactor.from_dict(obj["webAuthN"]) if obj.get("webAuthN") is not None else None,
            "intent": BetaSessionServiceIntentFactor.from_dict(obj["intent"]) if obj.get("intent") is not None else None,
            "totp": BetaSessionServiceTOTPFactor.from_dict(obj["totp"]) if obj.get("totp") is not None else None,
            "otpSms": BetaSessionServiceOTPFactor.from_dict(obj["otpSms"]) if obj.get("otpSms") is not None else None,
            "otpEmail": BetaSessionServiceOTPFactor.from_dict(obj["otpEmail"]) if obj.get("otpEmail") is not None else None
        })
        return _obj


