# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_session_service_creation_date_query import BetaSessionServiceCreationDateQuery
from zitadel_client.models.beta_session_service_ids_query import BetaSessionServiceIDsQuery
from zitadel_client.models.beta_session_service_user_id_query import BetaSessionServiceUserIDQuery
from typing import Optional, Set
from typing_extensions import Self

class BetaSessionServiceSearchQuery(BaseModel):
    """
    BetaSessionServiceSearchQuery
    """ # noqa: E501
    creation_date_query: Optional[BetaSessionServiceCreationDateQuery] = Field(default=None, alias="creationDateQuery")
    ids_query: Optional[BetaSessionServiceIDsQuery] = Field(default=None, alias="idsQuery")
    user_id_query: Optional[BetaSessionServiceUserIDQuery] = Field(default=None, alias="userIdQuery")
    __properties: ClassVar[List[str]] = ["creationDateQuery", "idsQuery", "userIdQuery"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaSessionServiceSearchQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation_date_query
        if self.creation_date_query:
            _dict['creationDateQuery'] = self.creation_date_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ids_query
        if self.ids_query:
            _dict['idsQuery'] = self.ids_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_id_query
        if self.user_id_query:
            _dict['userIdQuery'] = self.user_id_query.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaSessionServiceSearchQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creationDateQuery": BetaSessionServiceCreationDateQuery.from_dict(obj["creationDateQuery"]) if obj.get("creationDateQuery") is not None else None,
            "idsQuery": BetaSessionServiceIDsQuery.from_dict(obj["idsQuery"]) if obj.get("idsQuery") is not None else None,
            "userIdQuery": BetaSessionServiceUserIDQuery.from_dict(obj["userIdQuery"]) if obj.get("userIdQuery") is not None else None
        })
        return _obj


