# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_settings_service_resource_owner_type import BetaSettingsServiceResourceOwnerType
from zitadel_client.models.beta_settings_service_theme import BetaSettingsServiceTheme
from zitadel_client.models.beta_settings_service_theme_mode import BetaSettingsServiceThemeMode
from typing import Optional, Set
from typing_extensions import Self

class BetaSettingsServiceBrandingSettings(BaseModel):
    """
    BetaSettingsServiceBrandingSettings
    """ # noqa: E501
    light_theme: Optional[BetaSettingsServiceTheme] = Field(default=None, alias="lightTheme")
    dark_theme: Optional[BetaSettingsServiceTheme] = Field(default=None, alias="darkTheme")
    font_url: Optional[StrictStr] = Field(default=None, alias="fontUrl")
    hide_login_name_suffix: Optional[StrictBool] = Field(default=None, description="hides the org suffix on the login form if the scope \\\"urn:zitadel:iam:org:domain:primary:{domainname}\\\" is set", alias="hideLoginNameSuffix")
    disable_watermark: Optional[StrictBool] = Field(default=None, alias="disableWatermark")
    resource_owner_type: Optional[BetaSettingsServiceResourceOwnerType] = Field(default=None, alias="resourceOwnerType")
    theme_mode: Optional[BetaSettingsServiceThemeMode] = Field(default=None, alias="themeMode")
    __properties: ClassVar[List[str]] = ["lightTheme", "darkTheme", "fontUrl", "hideLoginNameSuffix", "disableWatermark", "resourceOwnerType", "themeMode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaSettingsServiceBrandingSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of light_theme
        if self.light_theme:
            _dict['lightTheme'] = self.light_theme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dark_theme
        if self.dark_theme:
            _dict['darkTheme'] = self.dark_theme.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaSettingsServiceBrandingSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lightTheme": BetaSettingsServiceTheme.from_dict(obj["lightTheme"]) if obj.get("lightTheme") is not None else None,
            "darkTheme": BetaSettingsServiceTheme.from_dict(obj["darkTheme"]) if obj.get("darkTheme") is not None else None,
            "fontUrl": obj.get("fontUrl"),
            "hideLoginNameSuffix": obj.get("hideLoginNameSuffix"),
            "disableWatermark": obj.get("disableWatermark"),
            "resourceOwnerType": obj.get("resourceOwnerType"),
            "themeMode": obj.get("themeMode")
        })
        return _obj


