# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.beta_user_service_hashed_password import BetaUserServiceHashedPassword
from zitadel_client.models.beta_user_service_idp_link import BetaUserServiceIDPLink
from zitadel_client.models.beta_user_service_organization import BetaUserServiceOrganization
from zitadel_client.models.beta_user_service_password import BetaUserServicePassword
from zitadel_client.models.beta_user_service_set_human_email import BetaUserServiceSetHumanEmail
from zitadel_client.models.beta_user_service_set_human_phone import BetaUserServiceSetHumanPhone
from zitadel_client.models.beta_user_service_set_human_profile import BetaUserServiceSetHumanProfile
from zitadel_client.models.beta_user_service_set_metadata_entry import BetaUserServiceSetMetadataEntry
from typing import Optional, Set
from typing_extensions import Self

class BetaUserServiceAddHumanUserRequest(BaseModel):
    """
    BetaUserServiceAddHumanUserRequest
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, description="optionally set your own id unique for the user.", alias="userId")
    username: Optional[StrictStr] = Field(default=None, description="optionally set a unique username, if none is provided the email will be used.")
    organization: Optional[BetaUserServiceOrganization] = None
    profile: Optional[BetaUserServiceSetHumanProfile] = None
    email: Optional[BetaUserServiceSetHumanEmail] = None
    phone: Optional[BetaUserServiceSetHumanPhone] = None
    metadata: Optional[List[BetaUserServiceSetMetadataEntry]] = None
    idp_links: Optional[List[BetaUserServiceIDPLink]] = Field(default=None, alias="idpLinks")
    totp_secret: Optional[StrictStr] = Field(default=None, description="An Implementation of RFC 6238 is used, with HMAC-SHA-1 and time-step of 30 seconds.  Currently no other options are supported, and if anything different is used the validation will fail.", alias="totpSecret")
    hashed_password: Optional[BetaUserServiceHashedPassword] = Field(default=None, alias="hashedPassword")
    password: Optional[BetaUserServicePassword] = None
    __properties: ClassVar[List[str]] = ["userId", "username", "organization", "profile", "email", "phone", "metadata", "idpLinks", "totpSecret", "hashedPassword", "password"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaUserServiceAddHumanUserRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of email
        if self.email:
            _dict['email'] = self.email.to_dict()
        # override the default output from pydantic by calling `to_dict()` of phone
        if self.phone:
            _dict['phone'] = self.phone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in metadata (list)
        _items = []
        if self.metadata:
            for _item_metadata in self.metadata:
                if _item_metadata:
                    _items.append(_item_metadata.to_dict())
            _dict['metadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in idp_links (list)
        _items = []
        if self.idp_links:
            for _item_idp_links in self.idp_links:
                if _item_idp_links:
                    _items.append(_item_idp_links.to_dict())
            _dict['idpLinks'] = _items
        # override the default output from pydantic by calling `to_dict()` of hashed_password
        if self.hashed_password:
            _dict['hashedPassword'] = self.hashed_password.to_dict()
        # override the default output from pydantic by calling `to_dict()` of password
        if self.password:
            _dict['password'] = self.password.to_dict()
        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['userId'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if totp_secret (nullable) is None
        # and model_fields_set contains the field
        if self.totp_secret is None and "totp_secret" in self.model_fields_set:
            _dict['totpSecret'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaUserServiceAddHumanUserRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "username": obj.get("username"),
            "organization": BetaUserServiceOrganization.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "profile": BetaUserServiceSetHumanProfile.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "email": BetaUserServiceSetHumanEmail.from_dict(obj["email"]) if obj.get("email") is not None else None,
            "phone": BetaUserServiceSetHumanPhone.from_dict(obj["phone"]) if obj.get("phone") is not None else None,
            "metadata": [BetaUserServiceSetMetadataEntry.from_dict(_item) for _item in obj["metadata"]] if obj.get("metadata") is not None else None,
            "idpLinks": [BetaUserServiceIDPLink.from_dict(_item) for _item in obj["idpLinks"]] if obj.get("idpLinks") is not None else None,
            "totpSecret": obj.get("totpSecret"),
            "hashedPassword": BetaUserServiceHashedPassword.from_dict(obj["hashedPassword"]) if obj.get("hashedPassword") is not None else None,
            "password": BetaUserServicePassword.from_dict(obj["password"]) if obj.get("password") is not None else None
        })
        return _obj


