# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.beta_user_service_display_name_query import BetaUserServiceDisplayNameQuery
from zitadel_client.models.beta_user_service_email_query import BetaUserServiceEmailQuery
from zitadel_client.models.beta_user_service_first_name_query import BetaUserServiceFirstNameQuery
from zitadel_client.models.beta_user_service_in_user_emails_query import BetaUserServiceInUserEmailsQuery
from zitadel_client.models.beta_user_service_in_user_id_query import BetaUserServiceInUserIDQuery
from zitadel_client.models.beta_user_service_last_name_query import BetaUserServiceLastNameQuery
from zitadel_client.models.beta_user_service_login_name_query import BetaUserServiceLoginNameQuery
from zitadel_client.models.beta_user_service_nick_name_query import BetaUserServiceNickNameQuery
from zitadel_client.models.beta_user_service_organization_id_query import BetaUserServiceOrganizationIdQuery
from zitadel_client.models.beta_user_service_phone_query import BetaUserServicePhoneQuery
from zitadel_client.models.beta_user_service_state_query import BetaUserServiceStateQuery
from zitadel_client.models.beta_user_service_type_query import BetaUserServiceTypeQuery
from zitadel_client.models.beta_user_service_user_name_query import BetaUserServiceUserNameQuery
from typing import Optional, Set
from typing_extensions import Self

class BetaUserServiceSearchQuery(BaseModel):
    """
    BetaUserServiceSearchQuery
    """ # noqa: E501
    and_query: Optional[BetaUserServiceAndQuery] = Field(default=None, alias="andQuery")
    display_name_query: Optional[BetaUserServiceDisplayNameQuery] = Field(default=None, alias="displayNameQuery")
    email_query: Optional[BetaUserServiceEmailQuery] = Field(default=None, alias="emailQuery")
    first_name_query: Optional[BetaUserServiceFirstNameQuery] = Field(default=None, alias="firstNameQuery")
    in_user_emails_query: Optional[BetaUserServiceInUserEmailsQuery] = Field(default=None, alias="inUserEmailsQuery")
    in_user_ids_query: Optional[BetaUserServiceInUserIDQuery] = Field(default=None, alias="inUserIdsQuery")
    last_name_query: Optional[BetaUserServiceLastNameQuery] = Field(default=None, alias="lastNameQuery")
    login_name_query: Optional[BetaUserServiceLoginNameQuery] = Field(default=None, alias="loginNameQuery")
    nick_name_query: Optional[BetaUserServiceNickNameQuery] = Field(default=None, alias="nickNameQuery")
    not_query: Optional[BetaUserServiceNotQuery] = Field(default=None, alias="notQuery")
    or_query: Optional[BetaUserServiceOrQuery] = Field(default=None, alias="orQuery")
    organization_id_query: Optional[BetaUserServiceOrganizationIdQuery] = Field(default=None, alias="organizationIdQuery")
    phone_query: Optional[BetaUserServicePhoneQuery] = Field(default=None, alias="phoneQuery")
    state_query: Optional[BetaUserServiceStateQuery] = Field(default=None, alias="stateQuery")
    type_query: Optional[BetaUserServiceTypeQuery] = Field(default=None, alias="typeQuery")
    user_name_query: Optional[BetaUserServiceUserNameQuery] = Field(default=None, alias="userNameQuery")
    __properties: ClassVar[List[str]] = ["andQuery", "displayNameQuery", "emailQuery", "firstNameQuery", "inUserEmailsQuery", "inUserIdsQuery", "lastNameQuery", "loginNameQuery", "nickNameQuery", "notQuery", "orQuery", "organizationIdQuery", "phoneQuery", "stateQuery", "typeQuery", "userNameQuery"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaUserServiceSearchQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of and_query
        if self.and_query:
            _dict['andQuery'] = self.and_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of display_name_query
        if self.display_name_query:
            _dict['displayNameQuery'] = self.display_name_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of email_query
        if self.email_query:
            _dict['emailQuery'] = self.email_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of first_name_query
        if self.first_name_query:
            _dict['firstNameQuery'] = self.first_name_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of in_user_emails_query
        if self.in_user_emails_query:
            _dict['inUserEmailsQuery'] = self.in_user_emails_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of in_user_ids_query
        if self.in_user_ids_query:
            _dict['inUserIdsQuery'] = self.in_user_ids_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_name_query
        if self.last_name_query:
            _dict['lastNameQuery'] = self.last_name_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of login_name_query
        if self.login_name_query:
            _dict['loginNameQuery'] = self.login_name_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nick_name_query
        if self.nick_name_query:
            _dict['nickNameQuery'] = self.nick_name_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of not_query
        if self.not_query:
            _dict['notQuery'] = self.not_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of or_query
        if self.or_query:
            _dict['orQuery'] = self.or_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization_id_query
        if self.organization_id_query:
            _dict['organizationIdQuery'] = self.organization_id_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of phone_query
        if self.phone_query:
            _dict['phoneQuery'] = self.phone_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state_query
        if self.state_query:
            _dict['stateQuery'] = self.state_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type_query
        if self.type_query:
            _dict['typeQuery'] = self.type_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_name_query
        if self.user_name_query:
            _dict['userNameQuery'] = self.user_name_query.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaUserServiceSearchQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "andQuery": BetaUserServiceAndQuery.from_dict(obj["andQuery"]) if obj.get("andQuery") is not None else None,
            "displayNameQuery": BetaUserServiceDisplayNameQuery.from_dict(obj["displayNameQuery"]) if obj.get("displayNameQuery") is not None else None,
            "emailQuery": BetaUserServiceEmailQuery.from_dict(obj["emailQuery"]) if obj.get("emailQuery") is not None else None,
            "firstNameQuery": BetaUserServiceFirstNameQuery.from_dict(obj["firstNameQuery"]) if obj.get("firstNameQuery") is not None else None,
            "inUserEmailsQuery": BetaUserServiceInUserEmailsQuery.from_dict(obj["inUserEmailsQuery"]) if obj.get("inUserEmailsQuery") is not None else None,
            "inUserIdsQuery": BetaUserServiceInUserIDQuery.from_dict(obj["inUserIdsQuery"]) if obj.get("inUserIdsQuery") is not None else None,
            "lastNameQuery": BetaUserServiceLastNameQuery.from_dict(obj["lastNameQuery"]) if obj.get("lastNameQuery") is not None else None,
            "loginNameQuery": BetaUserServiceLoginNameQuery.from_dict(obj["loginNameQuery"]) if obj.get("loginNameQuery") is not None else None,
            "nickNameQuery": BetaUserServiceNickNameQuery.from_dict(obj["nickNameQuery"]) if obj.get("nickNameQuery") is not None else None,
            "notQuery": BetaUserServiceNotQuery.from_dict(obj["notQuery"]) if obj.get("notQuery") is not None else None,
            "orQuery": BetaUserServiceOrQuery.from_dict(obj["orQuery"]) if obj.get("orQuery") is not None else None,
            "organizationIdQuery": BetaUserServiceOrganizationIdQuery.from_dict(obj["organizationIdQuery"]) if obj.get("organizationIdQuery") is not None else None,
            "phoneQuery": BetaUserServicePhoneQuery.from_dict(obj["phoneQuery"]) if obj.get("phoneQuery") is not None else None,
            "stateQuery": BetaUserServiceStateQuery.from_dict(obj["stateQuery"]) if obj.get("stateQuery") is not None else None,
            "typeQuery": BetaUserServiceTypeQuery.from_dict(obj["typeQuery"]) if obj.get("typeQuery") is not None else None,
            "userNameQuery": BetaUserServiceUserNameQuery.from_dict(obj["userNameQuery"]) if obj.get("userNameQuery") is not None else None
        })
        return _obj

from zitadel_client.models.beta_user_service_and_query import BetaUserServiceAndQuery
from zitadel_client.models.beta_user_service_not_query import BetaUserServiceNotQuery
from zitadel_client.models.beta_user_service_or_query import BetaUserServiceOrQuery
# TODO: Rewrite to not use raise_errors
BetaUserServiceSearchQuery.model_rebuild(raise_errors=False)

