# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.beta_user_service_details import BetaUserServiceDetails
from zitadel_client.models.beta_user_service_human_user import BetaUserServiceHumanUser
from zitadel_client.models.beta_user_service_machine_user import BetaUserServiceMachineUser
from zitadel_client.models.beta_user_service_user_state import BetaUserServiceUserState
from typing import Optional, Set
from typing_extensions import Self

class BetaUserServiceUser(BaseModel):
    """
    BetaUserServiceUser
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    details: Optional[BetaUserServiceDetails] = None
    state: Optional[BetaUserServiceUserState] = None
    username: Optional[StrictStr] = None
    login_names: Optional[List[StrictStr]] = Field(default=None, alias="loginNames")
    preferred_login_name: Optional[StrictStr] = Field(default=None, alias="preferredLoginName")
    human: Optional[BetaUserServiceHumanUser] = None
    machine: Optional[BetaUserServiceMachineUser] = None
    __properties: ClassVar[List[str]] = ["userId", "details", "state", "username", "loginNames", "preferredLoginName", "human", "machine"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BetaUserServiceUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict['details'] = self.details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of human
        if self.human:
            _dict['human'] = self.human.to_dict()
        # override the default output from pydantic by calling `to_dict()` of machine
        if self.machine:
            _dict['machine'] = self.machine.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BetaUserServiceUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "details": BetaUserServiceDetails.from_dict(obj["details"]) if obj.get("details") is not None else None,
            "state": obj.get("state"),
            "username": obj.get("username"),
            "loginNames": obj.get("loginNames"),
            "preferredLoginName": obj.get("preferredLoginName"),
            "human": BetaUserServiceHumanUser.from_dict(obj["human"]) if obj.get("human") is not None else None,
            "machine": BetaUserServiceMachineUser.from_dict(obj["machine"]) if obj.get("machine") is not None else None
        })
        return _obj


