# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.feature_service_details import FeatureServiceDetails
from zitadel_client.models.feature_service_feature_flag import FeatureServiceFeatureFlag
from zitadel_client.models.feature_service_improved_performance_feature_flag import FeatureServiceImprovedPerformanceFeatureFlag
from zitadel_client.models.feature_service_login_v2_feature_flag import FeatureServiceLoginV2FeatureFlag
from typing import Optional, Set
from typing_extensions import Self

class FeatureServiceGetInstanceFeaturesResponse(BaseModel):
    """
    FeatureServiceGetInstanceFeaturesResponse
    """ # noqa: E501
    details: Optional[FeatureServiceDetails] = None
    login_default_org: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="loginDefaultOrg")
    user_schema: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="userSchema")
    oidc_token_exchange: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="oidcTokenExchange")
    improved_performance: Optional[FeatureServiceImprovedPerformanceFeatureFlag] = Field(default=None, alias="improvedPerformance")
    debug_oidc_parent_error: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="debugOidcParentError")
    oidc_single_v1_session_termination: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="oidcSingleV1SessionTermination")
    enable_back_channel_logout: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="enableBackChannelLogout")
    login_v2: Optional[FeatureServiceLoginV2FeatureFlag] = Field(default=None, alias="loginV2")
    permission_check_v2: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="permissionCheckV2")
    console_use_v2_user_api: Optional[FeatureServiceFeatureFlag] = Field(default=None, alias="consoleUseV2UserApi")
    __properties: ClassVar[List[str]] = ["details", "loginDefaultOrg", "userSchema", "oidcTokenExchange", "improvedPerformance", "debugOidcParentError", "oidcSingleV1SessionTermination", "enableBackChannelLogout", "loginV2", "permissionCheckV2", "consoleUseV2UserApi"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FeatureServiceGetInstanceFeaturesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict['details'] = self.details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of login_default_org
        if self.login_default_org:
            _dict['loginDefaultOrg'] = self.login_default_org.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_schema
        if self.user_schema:
            _dict['userSchema'] = self.user_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oidc_token_exchange
        if self.oidc_token_exchange:
            _dict['oidcTokenExchange'] = self.oidc_token_exchange.to_dict()
        # override the default output from pydantic by calling `to_dict()` of improved_performance
        if self.improved_performance:
            _dict['improvedPerformance'] = self.improved_performance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of debug_oidc_parent_error
        if self.debug_oidc_parent_error:
            _dict['debugOidcParentError'] = self.debug_oidc_parent_error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oidc_single_v1_session_termination
        if self.oidc_single_v1_session_termination:
            _dict['oidcSingleV1SessionTermination'] = self.oidc_single_v1_session_termination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enable_back_channel_logout
        if self.enable_back_channel_logout:
            _dict['enableBackChannelLogout'] = self.enable_back_channel_logout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of login_v2
        if self.login_v2:
            _dict['loginV2'] = self.login_v2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permission_check_v2
        if self.permission_check_v2:
            _dict['permissionCheckV2'] = self.permission_check_v2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of console_use_v2_user_api
        if self.console_use_v2_user_api:
            _dict['consoleUseV2UserApi'] = self.console_use_v2_user_api.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FeatureServiceGetInstanceFeaturesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "details": FeatureServiceDetails.from_dict(obj["details"]) if obj.get("details") is not None else None,
            "loginDefaultOrg": FeatureServiceFeatureFlag.from_dict(obj["loginDefaultOrg"]) if obj.get("loginDefaultOrg") is not None else None,
            "userSchema": FeatureServiceFeatureFlag.from_dict(obj["userSchema"]) if obj.get("userSchema") is not None else None,
            "oidcTokenExchange": FeatureServiceFeatureFlag.from_dict(obj["oidcTokenExchange"]) if obj.get("oidcTokenExchange") is not None else None,
            "improvedPerformance": FeatureServiceImprovedPerformanceFeatureFlag.from_dict(obj["improvedPerformance"]) if obj.get("improvedPerformance") is not None else None,
            "debugOidcParentError": FeatureServiceFeatureFlag.from_dict(obj["debugOidcParentError"]) if obj.get("debugOidcParentError") is not None else None,
            "oidcSingleV1SessionTermination": FeatureServiceFeatureFlag.from_dict(obj["oidcSingleV1SessionTermination"]) if obj.get("oidcSingleV1SessionTermination") is not None else None,
            "enableBackChannelLogout": FeatureServiceFeatureFlag.from_dict(obj["enableBackChannelLogout"]) if obj.get("enableBackChannelLogout") is not None else None,
            "loginV2": FeatureServiceLoginV2FeatureFlag.from_dict(obj["loginV2"]) if obj.get("loginV2") is not None else None,
            "permissionCheckV2": FeatureServiceFeatureFlag.from_dict(obj["permissionCheckV2"]) if obj.get("permissionCheckV2") is not None else None,
            "consoleUseV2UserApi": FeatureServiceFeatureFlag.from_dict(obj["consoleUseV2UserApi"]) if obj.get("consoleUseV2UserApi") is not None else None
        })
        return _obj


