# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.feature_service_improved_performance import FeatureServiceImprovedPerformance
from zitadel_client.models.feature_service_login_v2 import FeatureServiceLoginV2
from typing import Optional, Set
from typing_extensions import Self

class FeatureServiceSetSystemFeaturesRequest(BaseModel):
    """
    FeatureServiceSetSystemFeaturesRequest
    """ # noqa: E501
    login_default_org: Optional[StrictBool] = Field(default=None, alias="loginDefaultOrg")
    user_schema: Optional[StrictBool] = Field(default=None, alias="userSchema")
    oidc_token_exchange: Optional[StrictBool] = Field(default=None, alias="oidcTokenExchange")
    improved_performance: Optional[List[FeatureServiceImprovedPerformance]] = Field(default=None, alias="improvedPerformance")
    oidc_single_v1_session_termination: Optional[StrictBool] = Field(default=None, alias="oidcSingleV1SessionTermination")
    enable_back_channel_logout: Optional[StrictBool] = Field(default=None, alias="enableBackChannelLogout")
    login_v2: Optional[FeatureServiceLoginV2] = Field(default=None, alias="loginV2")
    permission_check_v2: Optional[StrictBool] = Field(default=None, alias="permissionCheckV2")
    __properties: ClassVar[List[str]] = ["loginDefaultOrg", "userSchema", "oidcTokenExchange", "improvedPerformance", "oidcSingleV1SessionTermination", "enableBackChannelLogout", "loginV2", "permissionCheckV2"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FeatureServiceSetSystemFeaturesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of login_v2
        if self.login_v2:
            _dict['loginV2'] = self.login_v2.to_dict()
        # set to None if login_default_org (nullable) is None
        # and model_fields_set contains the field
        if self.login_default_org is None and "login_default_org" in self.model_fields_set:
            _dict['loginDefaultOrg'] = None

        # set to None if user_schema (nullable) is None
        # and model_fields_set contains the field
        if self.user_schema is None and "user_schema" in self.model_fields_set:
            _dict['userSchema'] = None

        # set to None if oidc_token_exchange (nullable) is None
        # and model_fields_set contains the field
        if self.oidc_token_exchange is None and "oidc_token_exchange" in self.model_fields_set:
            _dict['oidcTokenExchange'] = None

        # set to None if oidc_single_v1_session_termination (nullable) is None
        # and model_fields_set contains the field
        if self.oidc_single_v1_session_termination is None and "oidc_single_v1_session_termination" in self.model_fields_set:
            _dict['oidcSingleV1SessionTermination'] = None

        # set to None if enable_back_channel_logout (nullable) is None
        # and model_fields_set contains the field
        if self.enable_back_channel_logout is None and "enable_back_channel_logout" in self.model_fields_set:
            _dict['enableBackChannelLogout'] = None

        # set to None if permission_check_v2 (nullable) is None
        # and model_fields_set contains the field
        if self.permission_check_v2 is None and "permission_check_v2" in self.model_fields_set:
            _dict['permissionCheckV2'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FeatureServiceSetSystemFeaturesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "loginDefaultOrg": obj.get("loginDefaultOrg"),
            "userSchema": obj.get("userSchema"),
            "oidcTokenExchange": obj.get("oidcTokenExchange"),
            "improvedPerformance": obj.get("improvedPerformance"),
            "oidcSingleV1SessionTermination": obj.get("oidcSingleV1SessionTermination"),
            "enableBackChannelLogout": obj.get("enableBackChannelLogout"),
            "loginV2": FeatureServiceLoginV2.from_dict(obj["loginV2"]) if obj.get("loginV2") is not None else None,
            "permissionCheckV2": obj.get("permissionCheckV2")
        })
        return _obj


