# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from zitadel_client.models.identity_provider_service_azure_ad_tenant import IdentityProviderServiceAzureADTenant
from typing import Optional, Set
from typing_extensions import Self

class IdentityProviderServiceAzureADConfig(BaseModel):
    """
    IdentityProviderServiceAzureADConfig
    """ # noqa: E501
    client_id: Optional[StrictStr] = Field(default=None, description="Client id of the Azure AD application", alias="clientId")
    tenant: Optional[IdentityProviderServiceAzureADTenant] = None
    email_verified: Optional[StrictBool] = Field(default=None, description="Azure AD doesn't send if the email has been verified. Enable this if the  user email should always be added verified in ZITADEL (no verification  emails will be sent).", alias="emailVerified")
    scopes: Optional[List[StrictStr]] = Field(default=None, description="The scopes requested by ZITADEL during the request to Azure AD.")
    __properties: ClassVar[List[str]] = ["clientId", "tenant", "emailVerified", "scopes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceAzureADConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tenant
        if self.tenant:
            _dict['tenant'] = self.tenant.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceAzureADConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientId": obj.get("clientId"),
            "tenant": IdentityProviderServiceAzureADTenant.from_dict(obj["tenant"]) if obj.get("tenant") is not None else None,
            "emailVerified": obj.get("emailVerified"),
            "scopes": obj.get("scopes")
        })
        return _obj


