# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class IdentityProviderServiceDetails(BaseModel):
    """
    IdentityProviderServiceDetails
    """ # noqa: E501
    sequence: Optional[Any] = Field(default=None, description="sequence represents the order of events. It's always counting   on read: the sequence of the last event reduced by the projection   on manipulation: the timestamp of the event(s) added by the manipulation")
    change_date: Optional[datetime] = Field(default=None, description="A Timestamp represents a point in time independent of any time zone or local  calendar, encoded as a count of seconds and fractions of seconds at  nanosecond resolution. The count is relative to an epoch at UTC midnight on  January 1, 1970, in the proleptic Gregorian calendar which extends the  Gregorian calendar backwards to year one.   All minutes are 60 seconds long. Leap seconds are \"smeared\" so that no leap  second table is needed for interpretation, using a [24-hour linear  smear](https://developers.google.com/time/smear).   The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By  restricting to that range, we ensure that we can convert to and from [RFC  3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.   # Examples   Example 1: Compute Timestamp from POSIX `time()`.       Timestamp timestamp;      timestamp.set_seconds(time(NULL));      timestamp.set_nanos(0);   Example 2: Compute Timestamp from POSIX `gettimeofday()`.       struct timeval tv;      gettimeofday(&tv, NULL);       Timestamp timestamp;      timestamp.set_seconds(tv.tv_sec);      timestamp.set_nanos(tv.tv_usec * 1000);   Example 3: Compute Timestamp from Win32 `GetSystemTimeAsFileTime()`.       FILETIME ft;      GetSystemTimeAsFileTime(&ft);      UINT64 ticks = (((UINT64)ft.dwHighDateTime) << 32) | ft.dwLowDateTime;       // A Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z      // is 11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z.      Timestamp timestamp;      timestamp.set_seconds((INT64) ((ticks / 10000000) - 11644473600LL));      timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));   Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.       long millis = System.currentTimeMillis();       Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000)          .setNanos((int) ((millis % 1000) * 1000000)).build();   Example 5: Compute Timestamp from Java `Instant.now()`.       Instant now = Instant.now();       Timestamp timestamp =          Timestamp.newBuilder().setSeconds(now.getEpochSecond())              .setNanos(now.getNano()).build();   Example 6: Compute Timestamp from current time in Python.       timestamp = Timestamp()      timestamp.GetCurrentTime()   # JSON Mapping   In JSON format, the Timestamp type is encoded as a string in the  [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the  format is \"{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z\"  where {year} is always expressed using four digits while {month}, {day},  {hour}, {min}, and {sec} are zero-padded to two digits each. The fractional  seconds, which can go up to 9 digits (i.e. up to 1 nanosecond resolution),  are optional. The \"Z\" suffix indicates the timezone (\"UTC\"); the timezone  is required. A proto3 JSON serializer should always use UTC (as indicated by  \"Z\") when printing the Timestamp type and a proto3 JSON parser should be  able to accept both UTC and other timezones (as indicated by an offset).   For example, \"2017-01-15T01:30:15.01Z\" encodes 15.01 seconds past  01:30 UTC on January 15, 2017.   In JavaScript, one can convert a Date object to this format using the  standard  [toISOString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString)  method. In Python, a standard `datetime.datetime` object can be converted  to this format using  [`strftime`](https://docs.python.org/2/library/time.html#time.strftime) with  the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one can use  the Joda Time's [`ISODateTimeFormat.dateTime()`](  http://joda-time.sourceforge.net/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime()  ) to obtain a formatter capable of generating timestamps in this format.", alias="changeDate")
    resource_owner: Optional[StrictStr] = Field(default=None, description="resource_owner is the organization or instance_id an object belongs to", alias="resourceOwner")
    creation_date: Optional[datetime] = Field(default=None, description="A Timestamp represents a point in time independent of any time zone or local  calendar, encoded as a count of seconds and fractions of seconds at  nanosecond resolution. The count is relative to an epoch at UTC midnight on  January 1, 1970, in the proleptic Gregorian calendar which extends the  Gregorian calendar backwards to year one.   All minutes are 60 seconds long. Leap seconds are \"smeared\" so that no leap  second table is needed for interpretation, using a [24-hour linear  smear](https://developers.google.com/time/smear).   The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By  restricting to that range, we ensure that we can convert to and from [RFC  3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.   # Examples   Example 1: Compute Timestamp from POSIX `time()`.       Timestamp timestamp;      timestamp.set_seconds(time(NULL));      timestamp.set_nanos(0);   Example 2: Compute Timestamp from POSIX `gettimeofday()`.       struct timeval tv;      gettimeofday(&tv, NULL);       Timestamp timestamp;      timestamp.set_seconds(tv.tv_sec);      timestamp.set_nanos(tv.tv_usec * 1000);   Example 3: Compute Timestamp from Win32 `GetSystemTimeAsFileTime()`.       FILETIME ft;      GetSystemTimeAsFileTime(&ft);      UINT64 ticks = (((UINT64)ft.dwHighDateTime) << 32) | ft.dwLowDateTime;       // A Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z      // is 11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z.      Timestamp timestamp;      timestamp.set_seconds((INT64) ((ticks / 10000000) - 11644473600LL));      timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));   Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.       long millis = System.currentTimeMillis();       Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000)          .setNanos((int) ((millis % 1000) * 1000000)).build();   Example 5: Compute Timestamp from Java `Instant.now()`.       Instant now = Instant.now();       Timestamp timestamp =          Timestamp.newBuilder().setSeconds(now.getEpochSecond())              .setNanos(now.getNano()).build();   Example 6: Compute Timestamp from current time in Python.       timestamp = Timestamp()      timestamp.GetCurrentTime()   # JSON Mapping   In JSON format, the Timestamp type is encoded as a string in the  [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the  format is \"{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z\"  where {year} is always expressed using four digits while {month}, {day},  {hour}, {min}, and {sec} are zero-padded to two digits each. The fractional  seconds, which can go up to 9 digits (i.e. up to 1 nanosecond resolution),  are optional. The \"Z\" suffix indicates the timezone (\"UTC\"); the timezone  is required. A proto3 JSON serializer should always use UTC (as indicated by  \"Z\") when printing the Timestamp type and a proto3 JSON parser should be  able to accept both UTC and other timezones (as indicated by an offset).   For example, \"2017-01-15T01:30:15.01Z\" encodes 15.01 seconds past  01:30 UTC on January 15, 2017.   In JavaScript, one can convert a Date object to this format using the  standard  [toISOString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString)  method. In Python, a standard `datetime.datetime` object can be converted  to this format using  [`strftime`](https://docs.python.org/2/library/time.html#time.strftime) with  the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one can use  the Joda Time's [`ISODateTimeFormat.dateTime()`](  http://joda-time.sourceforge.net/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime()  ) to obtain a formatter capable of generating timestamps in this format.", alias="creationDate")
    __properties: ClassVar[List[str]] = ["sequence", "changeDate", "resourceOwner", "creationDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if sequence (nullable) is None
        # and model_fields_set contains the field
        if self.sequence is None and "sequence" in self.model_fields_set:
            _dict['sequence'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sequence": obj.get("sequence"),
            "changeDate": obj.get("changeDate"),
            "resourceOwner": obj.get("resourceOwner"),
            "creationDate": obj.get("creationDate")
        })
        return _obj


