# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from zitadel_client.models.identity_provider_service_ldap_attributes import IdentityProviderServiceLDAPAttributes
from typing import Optional, Set
from typing_extensions import Self

class IdentityProviderServiceLDAPConfig(BaseModel):
    """
    IdentityProviderServiceLDAPConfig
    """ # noqa: E501
    servers: Optional[List[StrictStr]] = None
    start_tls: Optional[StrictBool] = Field(default=None, alias="startTls")
    base_dn: Optional[StrictStr] = Field(default=None, alias="baseDn")
    bind_dn: Optional[StrictStr] = Field(default=None, alias="bindDn")
    user_base: Optional[StrictStr] = Field(default=None, alias="userBase")
    user_object_classes: Optional[List[StrictStr]] = Field(default=None, alias="userObjectClasses")
    user_filters: Optional[List[StrictStr]] = Field(default=None, alias="userFilters")
    timeout: Optional[StrictStr] = Field(default=None, description="A Duration represents a signed, fixed-length span of time represented  as a count of seconds and fractions of seconds at nanosecond  resolution. It is independent of any calendar and concepts like \"day\"  or \"month\". It is related to Timestamp in that the difference between  two Timestamp values is a Duration and it can be added or subtracted  from a Timestamp. Range is approximately +-10,000 years.   # Examples   Example 1: Compute Duration from two Timestamps in pseudo code.       Timestamp start = ...;      Timestamp end = ...;      Duration duration = ...;       duration.seconds = end.seconds - start.seconds;      duration.nanos = end.nanos - start.nanos;       if (duration.seconds < 0 && duration.nanos > 0) {        duration.seconds += 1;        duration.nanos -= 1000000000;      } else if (duration.seconds > 0 && duration.nanos < 0) {        duration.seconds -= 1;        duration.nanos += 1000000000;      }   Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.       Timestamp start = ...;      Duration duration = ...;      Timestamp end = ...;       end.seconds = start.seconds + duration.seconds;      end.nanos = start.nanos + duration.nanos;       if (end.nanos < 0) {        end.seconds -= 1;        end.nanos += 1000000000;      } else if (end.nanos >= 1000000000) {        end.seconds += 1;        end.nanos -= 1000000000;      }   Example 3: Compute Duration from datetime.timedelta in Python.       td = datetime.timedelta(days=3, minutes=10)      duration = Duration()      duration.FromTimedelta(td)   # JSON Mapping   In JSON format, the Duration type is encoded as a string rather than an  object, where the string ends in the suffix \"s\" (indicating seconds) and  is preceded by the number of seconds, with nanoseconds expressed as  fractional seconds. For example, 3 seconds with 0 nanoseconds should be  encoded in JSON format as \"3s\", while 3 seconds and 1 nanosecond should  be expressed in JSON format as \"3.000000001s\", and 3 seconds and 1  microsecond should be expressed in JSON format as \"3.000001s\".")
    attributes: Optional[IdentityProviderServiceLDAPAttributes] = None
    root_ca: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, alias="rootCa")
    __properties: ClassVar[List[str]] = ["servers", "startTls", "baseDn", "bindDn", "userBase", "userObjectClasses", "userFilters", "timeout", "attributes", "rootCa"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceLDAPConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attributes
        if self.attributes:
            _dict['attributes'] = self.attributes.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceLDAPConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "servers": obj.get("servers"),
            "startTls": obj.get("startTls"),
            "baseDn": obj.get("baseDn"),
            "bindDn": obj.get("bindDn"),
            "userBase": obj.get("userBase"),
            "userObjectClasses": obj.get("userObjectClasses"),
            "userFilters": obj.get("userFilters"),
            "timeout": obj.get("timeout"),
            "attributes": IdentityProviderServiceLDAPAttributes.from_dict(obj["attributes"]) if obj.get("attributes") is not None else None,
            "rootCa": obj.get("rootCa")
        })
        return _obj


