# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, Optional, Union
from zitadel_client.models.identity_provider_service_saml_binding import IdentityProviderServiceSAMLBinding
from zitadel_client.models.identity_provider_service_saml_name_id_format import IdentityProviderServiceSAMLNameIDFormat
from zitadel_client.models.identity_provider_service_saml_signature_algorithm import IdentityProviderServiceSAMLSignatureAlgorithm
from typing import Optional, Set
from typing_extensions import Self

class IdentityProviderServiceSAMLConfig(BaseModel):
    """
    IdentityProviderServiceSAMLConfig
    """ # noqa: E501
    metadata_xml: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, description="Metadata of the SAML identity provider.", alias="metadataXml")
    binding: Optional[IdentityProviderServiceSAMLBinding] = None
    with_signed_request: Optional[StrictBool] = Field(default=None, description="Boolean which defines if the authentication requests are signed.", alias="withSignedRequest")
    name_id_format: Optional[IdentityProviderServiceSAMLNameIDFormat] = Field(default=None, alias="nameIdFormat")
    transient_mapping_attribute_name: Optional[StrictStr] = Field(default=None, description="Optional name of the attribute, which will be used to map the user  in case the nameid-format returned is  `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.", alias="transientMappingAttributeName")
    federated_logout_enabled: Optional[StrictBool] = Field(default=None, description="Boolean weather federated logout is enabled. If enabled, ZITADEL will send a logout request to the identity provider,  if the user terminates the session in ZITADEL. Be sure to provide a SLO endpoint as part of the metadata.", alias="federatedLogoutEnabled")
    signature_algorithm: Optional[IdentityProviderServiceSAMLSignatureAlgorithm] = Field(default=None, alias="signatureAlgorithm")
    __properties: ClassVar[List[str]] = ["metadataXml", "binding", "withSignedRequest", "nameIdFormat", "transientMappingAttributeName", "federatedLogoutEnabled", "signatureAlgorithm"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceSAMLConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if transient_mapping_attribute_name (nullable) is None
        # and model_fields_set contains the field
        if self.transient_mapping_attribute_name is None and "transient_mapping_attribute_name" in self.model_fields_set:
            _dict['transientMappingAttributeName'] = None

        # set to None if federated_logout_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.federated_logout_enabled is None and "federated_logout_enabled" in self.model_fields_set:
            _dict['federatedLogoutEnabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityProviderServiceSAMLConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metadataXml": obj.get("metadataXml"),
            "binding": obj.get("binding"),
            "withSignedRequest": obj.get("withSignedRequest"),
            "nameIdFormat": obj.get("nameIdFormat"),
            "transientMappingAttributeName": obj.get("transientMappingAttributeName"),
            "federatedLogoutEnabled": obj.get("federatedLogoutEnabled"),
            "signatureAlgorithm": obj.get("signatureAlgorithm")
        })
        return _obj


