# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.organization_service_organization_domain_query import OrganizationServiceOrganizationDomainQuery
from zitadel_client.models.organization_service_organization_id_query import OrganizationServiceOrganizationIDQuery
from zitadel_client.models.organization_service_organization_name_query import OrganizationServiceOrganizationNameQuery
from zitadel_client.models.organization_service_organization_state_query import OrganizationServiceOrganizationStateQuery
from typing import Optional, Set
from typing_extensions import Self

class OrganizationServiceSearchQuery(BaseModel):
    """
    OrganizationServiceSearchQuery
    """ # noqa: E501
    default_query: Optional[Dict[str, Any]] = Field(default=None, alias="defaultQuery")
    domain_query: Optional[OrganizationServiceOrganizationDomainQuery] = Field(default=None, alias="domainQuery")
    id_query: Optional[OrganizationServiceOrganizationIDQuery] = Field(default=None, alias="idQuery")
    name_query: Optional[OrganizationServiceOrganizationNameQuery] = Field(default=None, alias="nameQuery")
    state_query: Optional[OrganizationServiceOrganizationStateQuery] = Field(default=None, alias="stateQuery")
    __properties: ClassVar[List[str]] = ["defaultQuery", "domainQuery", "idQuery", "nameQuery", "stateQuery"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationServiceSearchQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of domain_query
        if self.domain_query:
            _dict['domainQuery'] = self.domain_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of id_query
        if self.id_query:
            _dict['idQuery'] = self.id_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of name_query
        if self.name_query:
            _dict['nameQuery'] = self.name_query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state_query
        if self.state_query:
            _dict['stateQuery'] = self.state_query.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationServiceSearchQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultQuery": obj.get("defaultQuery"),
            "domainQuery": OrganizationServiceOrganizationDomainQuery.from_dict(obj["domainQuery"]) if obj.get("domainQuery") is not None else None,
            "idQuery": OrganizationServiceOrganizationIDQuery.from_dict(obj["idQuery"]) if obj.get("idQuery") is not None else None,
            "nameQuery": OrganizationServiceOrganizationNameQuery.from_dict(obj["nameQuery"]) if obj.get("nameQuery") is not None else None,
            "stateQuery": OrganizationServiceOrganizationStateQuery.from_dict(obj["stateQuery"]) if obj.get("stateQuery") is not None else None
        })
        return _obj


