# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.organization_service_gender import OrganizationServiceGender
from typing import Optional, Set
from typing_extensions import Self

class OrganizationServiceSetHumanProfile(BaseModel):
    """
    OrganizationServiceSetHumanProfile
    """ # noqa: E501
    given_name: Optional[StrictStr] = Field(default=None, alias="givenName")
    family_name: Optional[StrictStr] = Field(default=None, alias="familyName")
    nick_name: Optional[StrictStr] = Field(default=None, alias="nickName")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    preferred_language: Optional[StrictStr] = Field(default=None, alias="preferredLanguage")
    gender: Optional[OrganizationServiceGender] = None
    __properties: ClassVar[List[str]] = ["givenName", "familyName", "nickName", "displayName", "preferredLanguage", "gender"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationServiceSetHumanProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if nick_name (nullable) is None
        # and model_fields_set contains the field
        if self.nick_name is None and "nick_name" in self.model_fields_set:
            _dict['nickName'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        # set to None if preferred_language (nullable) is None
        # and model_fields_set contains the field
        if self.preferred_language is None and "preferred_language" in self.model_fields_set:
            _dict['preferredLanguage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationServiceSetHumanProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "givenName": obj.get("givenName"),
            "familyName": obj.get("familyName"),
            "nickName": obj.get("nickName"),
            "displayName": obj.get("displayName"),
            "preferredLanguage": obj.get("preferredLanguage"),
            "gender": obj.get("gender")
        })
        return _obj


