# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.settings_service_request_context import SettingsServiceRequestContext
from typing import Optional, Set
from typing_extensions import Self

class SettingsServiceGetActiveIdentityProvidersRequest(BaseModel):
    """
    SettingsServiceGetActiveIdentityProvidersRequest
    """ # noqa: E501
    ctx: Optional[SettingsServiceRequestContext] = None
    creation_allowed: Optional[StrictBool] = Field(default=None, alias="creationAllowed")
    linking_allowed: Optional[StrictBool] = Field(default=None, alias="linkingAllowed")
    auto_creation: Optional[StrictBool] = Field(default=None, alias="autoCreation")
    auto_linking: Optional[StrictBool] = Field(default=None, alias="autoLinking")
    __properties: ClassVar[List[str]] = ["ctx", "creationAllowed", "linkingAllowed", "autoCreation", "autoLinking"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SettingsServiceGetActiveIdentityProvidersRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ctx
        if self.ctx:
            _dict['ctx'] = self.ctx.to_dict()
        # set to None if creation_allowed (nullable) is None
        # and model_fields_set contains the field
        if self.creation_allowed is None and "creation_allowed" in self.model_fields_set:
            _dict['creationAllowed'] = None

        # set to None if linking_allowed (nullable) is None
        # and model_fields_set contains the field
        if self.linking_allowed is None and "linking_allowed" in self.model_fields_set:
            _dict['linkingAllowed'] = None

        # set to None if auto_creation (nullable) is None
        # and model_fields_set contains the field
        if self.auto_creation is None and "auto_creation" in self.model_fields_set:
            _dict['autoCreation'] = None

        # set to None if auto_linking (nullable) is None
        # and model_fields_set contains the field
        if self.auto_linking is None and "auto_linking" in self.model_fields_set:
            _dict['autoLinking'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SettingsServiceGetActiveIdentityProvidersRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ctx": SettingsServiceRequestContext.from_dict(obj["ctx"]) if obj.get("ctx") is not None else None,
            "creationAllowed": obj.get("creationAllowed"),
            "linkingAllowed": obj.get("linkingAllowed"),
            "autoCreation": obj.get("autoCreation"),
            "autoLinking": obj.get("autoLinking")
        })
        return _obj


