# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.user_service_human import UserServiceHuman
from zitadel_client.models.user_service_machine import UserServiceMachine
from typing import Optional, Set
from typing_extensions import Self

class UserServiceCreateUserRequest(BaseModel):
    """
    UserServiceCreateUserRequest
    """ # noqa: E501
    organization_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the organization the user belongs to.", alias="organizationId")
    user_id: Optional[StrictStr] = Field(default=None, description="The ID is a unique identifier for the user in the instance.  If not specified, it will be generated.  You can set your own user id that is unique within the instance.  This is useful in migration scenarios, for example if the user already has an ID in another Zitadel system.  If not specified, it will be generated.  It can't be changed after creation.", alias="userId")
    username: Optional[StrictStr] = Field(default=None, description="The username is a unique identifier for the user in the organization.  If not specified, Zitadel sets the username to the email for users of type human and to the user_id for users of type machine.  It is used to identify the user in the organization and can be used for login.")
    human: Optional[UserServiceHuman] = None
    machine: Optional[UserServiceMachine] = None
    __properties: ClassVar[List[str]] = ["organizationId", "userId", "username", "human", "machine"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserServiceCreateUserRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of human
        if self.human:
            _dict['human'] = self.human.to_dict()
        # override the default output from pydantic by calling `to_dict()` of machine
        if self.machine:
            _dict['machine'] = self.machine.to_dict()
        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['userId'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserServiceCreateUserRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organizationId": obj.get("organizationId"),
            "userId": obj.get("userId"),
            "username": obj.get("username"),
            "human": UserServiceHuman.from_dict(obj["human"]) if obj.get("human") is not None else None,
            "machine": UserServiceMachine.from_dict(obj["machine"]) if obj.get("machine") is not None else None
        })
        return _obj


