# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.user_service_idpldap_access_information import UserServiceIDPLDAPAccessInformation
from zitadel_client.models.user_service_idpo_auth_access_information import UserServiceIDPOAuthAccessInformation
from zitadel_client.models.user_service_idpsaml_access_information import UserServiceIDPSAMLAccessInformation
from typing import Optional, Set
from typing_extensions import Self

class UserServiceIDPInformation(BaseModel):
    """
    UserServiceIDPInformation
    """ # noqa: E501
    idp_id: Optional[StrictStr] = Field(default=None, alias="idpId")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    user_name: Optional[StrictStr] = Field(default=None, alias="userName")
    raw_information: Optional[Dict[str, Any]] = Field(default=None, description="`Struct` represents a structured data value, consisting of fields  which map to dynamically typed values. In some languages, `Struct`  might be supported by a native representation. For example, in  scripting languages like JS a struct is represented as an  object. The details of that representation are described together  with the proto support for the language.   The JSON representation for `Struct` is JSON object.", alias="rawInformation")
    ldap: Optional[UserServiceIDPLDAPAccessInformation] = None
    oauth: Optional[UserServiceIDPOAuthAccessInformation] = None
    saml: Optional[UserServiceIDPSAMLAccessInformation] = None
    __properties: ClassVar[List[str]] = ["idpId", "userId", "userName", "rawInformation", "ldap", "oauth", "saml"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserServiceIDPInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ldap
        if self.ldap:
            _dict['ldap'] = self.ldap.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oauth
        if self.oauth:
            _dict['oauth'] = self.oauth.to_dict()
        # override the default output from pydantic by calling `to_dict()` of saml
        if self.saml:
            _dict['saml'] = self.saml.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserServiceIDPInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "idpId": obj.get("idpId"),
            "userId": obj.get("userId"),
            "userName": obj.get("userName"),
            "rawInformation": obj.get("rawInformation"),
            "ldap": UserServiceIDPLDAPAccessInformation.from_dict(obj["ldap"]) if obj.get("ldap") is not None else None,
            "oauth": UserServiceIDPOAuthAccessInformation.from_dict(obj["oauth"]) if obj.get("oauth") is not None else None,
            "saml": UserServiceIDPSAMLAccessInformation.from_dict(obj["saml"]) if obj.get("saml") is not None else None
        })
        return _obj


