# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.user_service_id_filter import UserServiceIDFilter
from zitadel_client.models.user_service_timestamp_filter import UserServiceTimestampFilter
from typing import Optional, Set
from typing_extensions import Self

class UserServicePersonalAccessTokensSearchFilter(BaseModel):
    """
    UserServicePersonalAccessTokensSearchFilter
    """ # noqa: E501
    created_date_filter: Optional[UserServiceTimestampFilter] = Field(default=None, alias="createdDateFilter")
    expiration_date_filter: Optional[UserServiceTimestampFilter] = Field(default=None, alias="expirationDateFilter")
    organization_id_filter: Optional[UserServiceIDFilter] = Field(default=None, alias="organizationIdFilter")
    token_id_filter: Optional[UserServiceIDFilter] = Field(default=None, alias="tokenIdFilter")
    user_id_filter: Optional[UserServiceIDFilter] = Field(default=None, alias="userIdFilter")
    __properties: ClassVar[List[str]] = ["createdDateFilter", "expirationDateFilter", "organizationIdFilter", "tokenIdFilter", "userIdFilter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserServicePersonalAccessTokensSearchFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_date_filter
        if self.created_date_filter:
            _dict['createdDateFilter'] = self.created_date_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expiration_date_filter
        if self.expiration_date_filter:
            _dict['expirationDateFilter'] = self.expiration_date_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization_id_filter
        if self.organization_id_filter:
            _dict['organizationIdFilter'] = self.organization_id_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of token_id_filter
        if self.token_id_filter:
            _dict['tokenIdFilter'] = self.token_id_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_id_filter
        if self.user_id_filter:
            _dict['userIdFilter'] = self.user_id_filter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserServicePersonalAccessTokensSearchFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdDateFilter": UserServiceTimestampFilter.from_dict(obj["createdDateFilter"]) if obj.get("createdDateFilter") is not None else None,
            "expirationDateFilter": UserServiceTimestampFilter.from_dict(obj["expirationDateFilter"]) if obj.get("expirationDateFilter") is not None else None,
            "organizationIdFilter": UserServiceIDFilter.from_dict(obj["organizationIdFilter"]) if obj.get("organizationIdFilter") is not None else None,
            "tokenIdFilter": UserServiceIDFilter.from_dict(obj["tokenIdFilter"]) if obj.get("tokenIdFilter") is not None else None,
            "userIdFilter": UserServiceIDFilter.from_dict(obj["userIdFilter"]) if obj.get("userIdFilter") is not None else None
        })
        return _obj


