# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.user_service_gender import UserServiceGender
from typing import Optional, Set
from typing_extensions import Self

class UserServiceProfile(BaseModel):
    """
    UserServiceProfile
    """ # noqa: E501
    given_name: Optional[StrictStr] = Field(default=None, description="The given name is the first name of the user.  For example, it can be used to personalize notifications and login UIs.", alias="givenName")
    family_name: Optional[StrictStr] = Field(default=None, description="The family name is the last name of the user.  For example, it can be used to personalize user interfaces and notifications.", alias="familyName")
    nick_name: Optional[StrictStr] = Field(default=None, description="The nick name is the users short name.  For example, it can be used to personalize user interfaces and notifications.", alias="nickName")
    display_name: Optional[StrictStr] = Field(default=None, description="The display name is how a user should primarily be displayed in lists.  It can also for example be used to personalize user interfaces and notifications.", alias="displayName")
    preferred_language: Optional[StrictStr] = Field(default=None, description="The users preferred language is the language that systems should use to interact with the user.  It has the format of a [BCP-47 language tag](https://datatracker.ietf.org/doc/html/rfc3066).  It is used by Zitadel where no higher prioritized preferred language can be used.  For example, browser settings can overwrite a users preferred_language.  Notification messages and standard login UIs use the users preferred language if it is supported and allowed on the instance.  Else, the default language of the instance is used.", alias="preferredLanguage")
    gender: Optional[UserServiceGender] = None
    __properties: ClassVar[List[str]] = ["givenName", "familyName", "nickName", "displayName", "preferredLanguage", "gender"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserServiceProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if given_name (nullable) is None
        # and model_fields_set contains the field
        if self.given_name is None and "given_name" in self.model_fields_set:
            _dict['givenName'] = None

        # set to None if family_name (nullable) is None
        # and model_fields_set contains the field
        if self.family_name is None and "family_name" in self.model_fields_set:
            _dict['familyName'] = None

        # set to None if nick_name (nullable) is None
        # and model_fields_set contains the field
        if self.nick_name is None and "nick_name" in self.model_fields_set:
            _dict['nickName'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        # set to None if preferred_language (nullable) is None
        # and model_fields_set contains the field
        if self.preferred_language is None and "preferred_language" in self.model_fields_set:
            _dict['preferredLanguage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserServiceProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "givenName": obj.get("givenName"),
            "familyName": obj.get("familyName"),
            "nickName": obj.get("nickName"),
            "displayName": obj.get("displayName"),
            "preferredLanguage": obj.get("preferredLanguage"),
            "gender": obj.get("gender")
        })
        return _obj


