# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.user_service_hashed_password import UserServiceHashedPassword
from zitadel_client.models.user_service_password import UserServicePassword
from typing import Optional, Set
from typing_extensions import Self

class UserServiceSetPassword(BaseModel):
    """
    UserServiceSetPassword
    """ # noqa: E501
    hashed_password: Optional[UserServiceHashedPassword] = Field(default=None, alias="hashedPassword")
    password: Optional[UserServicePassword] = None
    current_password: Optional[StrictStr] = Field(default=None, alias="currentPassword")
    verification_code: Optional[StrictStr] = Field(default=None, alias="verificationCode")
    __properties: ClassVar[List[str]] = ["hashedPassword", "password", "currentPassword", "verificationCode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserServiceSetPassword from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of hashed_password
        if self.hashed_password:
            _dict['hashedPassword'] = self.hashed_password.to_dict()
        # override the default output from pydantic by calling `to_dict()` of password
        if self.password:
            _dict['password'] = self.password.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserServiceSetPassword from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hashedPassword": UserServiceHashedPassword.from_dict(obj["hashedPassword"]) if obj.get("hashedPassword") is not None else None,
            "password": UserServicePassword.from_dict(obj["password"]) if obj.get("password") is not None else None,
            "currentPassword": obj.get("currentPassword"),
            "verificationCode": obj.get("verificationCode")
        })
        return _obj


