# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, Optional, Union
from zitadel_client.models.user_service_details import UserServiceDetails
from zitadel_client.models.user_service_form_data import UserServiceFormData
from zitadel_client.models.user_service_idp_intent import UserServiceIDPIntent
from typing import Optional, Set
from typing_extensions import Self

class UserServiceStartIdentityProviderIntentResponse(BaseModel):
    """
    UserServiceStartIdentityProviderIntentResponse
    """ # noqa: E501
    details: Optional[UserServiceDetails] = None
    auth_url: Optional[StrictStr] = Field(default=None, alias="authUrl")
    form_data: Optional[UserServiceFormData] = Field(default=None, alias="formData")
    idp_intent: Optional[UserServiceIDPIntent] = Field(default=None, alias="idpIntent")
    post_form: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, description="POST call information  Deprecated: Use form_data instead", alias="postForm")
    __properties: ClassVar[List[str]] = ["details", "authUrl", "formData", "idpIntent", "postForm"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserServiceStartIdentityProviderIntentResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict['details'] = self.details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of form_data
        if self.form_data:
            _dict['formData'] = self.form_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of idp_intent
        if self.idp_intent:
            _dict['idpIntent'] = self.idp_intent.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserServiceStartIdentityProviderIntentResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "details": UserServiceDetails.from_dict(obj["details"]) if obj.get("details") is not None else None,
            "authUrl": obj.get("authUrl"),
            "formData": UserServiceFormData.from_dict(obj["formData"]) if obj.get("formData") is not None else None,
            "idpIntent": UserServiceIDPIntent.from_dict(obj["idpIntent"]) if obj.get("idpIntent") is not None else None,
            "postForm": obj.get("postForm")
        })
        return _obj


