# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.user_service_set_human_email import UserServiceSetHumanEmail
from zitadel_client.models.user_service_set_human_phone import UserServiceSetHumanPhone
from zitadel_client.models.user_service_set_human_profile import UserServiceSetHumanProfile
from zitadel_client.models.user_service_set_password import UserServiceSetPassword
from typing import Optional, Set
from typing_extensions import Self

class UserServiceUpdateHumanUserRequest(BaseModel):
    """
    UserServiceUpdateHumanUserRequest
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    username: Optional[StrictStr] = None
    profile: Optional[UserServiceSetHumanProfile] = None
    email: Optional[UserServiceSetHumanEmail] = None
    phone: Optional[UserServiceSetHumanPhone] = None
    password: Optional[UserServiceSetPassword] = None
    __properties: ClassVar[List[str]] = ["userId", "username", "profile", "email", "phone", "password"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserServiceUpdateHumanUserRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of email
        if self.email:
            _dict['email'] = self.email.to_dict()
        # override the default output from pydantic by calling `to_dict()` of phone
        if self.phone:
            _dict['phone'] = self.phone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of password
        if self.password:
            _dict['password'] = self.password.to_dict()
        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserServiceUpdateHumanUserRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "username": obj.get("username"),
            "profile": UserServiceSetHumanProfile.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "email": UserServiceSetHumanEmail.from_dict(obj["email"]) if obj.get("email") is not None else None,
            "phone": UserServiceSetHumanPhone.from_dict(obj["phone"]) if obj.get("phone") is not None else None,
            "password": UserServiceSetPassword.from_dict(obj["password"]) if obj.get("password") is not None else None
        })
        return _obj


