# coding: utf-8

"""
    Zitadel SDK

    The Zitadel SDK is a convenience wrapper around the Zitadel APIs to assist you in integrating with your Zitadel environment. This SDK enables you to handle resources, settings, and configurations within the Zitadel platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, Optional
from zitadel_client.models.web_key_service_ecdsa import WebKeyServiceECDSA
from zitadel_client.models.web_key_service_rsa import WebKeyServiceRSA
from typing import Optional, Set
from typing_extensions import Self

class WebKeyServiceCreateWebKeyRequest(BaseModel):
    """
    WebKeyServiceCreateWebKeyRequest
    """ # noqa: E501
    ecdsa: Optional[WebKeyServiceECDSA] = None
    ed25519: Optional[Dict[str, Any]] = None
    rsa: Optional[WebKeyServiceRSA] = None
    __properties: ClassVar[List[str]] = ["ecdsa", "ed25519", "rsa"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebKeyServiceCreateWebKeyRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ecdsa
        if self.ecdsa:
            _dict['ecdsa'] = self.ecdsa.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rsa
        if self.rsa:
            _dict['rsa'] = self.rsa.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebKeyServiceCreateWebKeyRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ecdsa": WebKeyServiceECDSA.from_dict(obj["ecdsa"]) if obj.get("ecdsa") is not None else None,
            "ed25519": obj.get("ed25519"),
            "rsa": WebKeyServiceRSA.from_dict(obj["rsa"]) if obj.get("rsa") is not None else None
        })
        return _obj


