# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppsecWafExclusionFilterArgs', 'AppsecWafExclusionFilter']

@pulumi.input_type
class AppsecWafExclusionFilterArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 event_query: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_targets: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterRulesTargetArgs']]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterScopeArgs']]]] = None):
        """
        The set of arguments for constructing a AppsecWafExclusionFilter resource.
        :param pulumi.Input[_builtins.str] description: A description for the exclusion filter.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the exclusion filter is enabled.
        :param pulumi.Input[_builtins.str] event_query: The event query matched by the legacy exclusion filter. Cannot be created nor updated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_lists: The client IP addresses matched by the exclusion filter (CIDR notation is supported).
        :param pulumi.Input[_builtins.str] on_match: The action taken when the exclusion filter matches. When set to `monitor`, security traces are emitted but the requests are not blocked. By default, security traces are not emitted and the requests are not blocked.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] parameters: A list of parameters matched by the exclusion filter in the HTTP query string and HTTP request body. Nested parameters can be matched by joining fields with a dot character.
        :param pulumi.Input[_builtins.str] path_glob: The HTTP path glob expression matched by the exclusion filter.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        if event_query is not None:
            pulumi.set(__self__, "event_query", event_query)
        if ip_lists is not None:
            pulumi.set(__self__, "ip_lists", ip_lists)
        if on_match is not None:
            pulumi.set(__self__, "on_match", on_match)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if path_glob is not None:
            pulumi.set(__self__, "path_glob", path_glob)
        if rules_targets is not None:
            pulumi.set(__self__, "rules_targets", rules_targets)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        A description for the exclusion filter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether the exclusion filter is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="eventQuery")
    def event_query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The event query matched by the legacy exclusion filter. Cannot be created nor updated.
        """
        return pulumi.get(self, "event_query")

    @event_query.setter
    def event_query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_query", value)

    @_builtins.property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The client IP addresses matched by the exclusion filter (CIDR notation is supported).
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="onMatch")
    def on_match(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action taken when the exclusion filter matches. When set to `monitor`, security traces are emitted but the requests are not blocked. By default, security traces are not emitted and the requests are not blocked.
        """
        return pulumi.get(self, "on_match")

    @on_match.setter
    def on_match(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_match", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of parameters matched by the exclusion filter in the HTTP query string and HTTP request body. Nested parameters can be matched by joining fields with a dot character.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="pathGlob")
    def path_glob(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP path glob expression matched by the exclusion filter.
        """
        return pulumi.get(self, "path_glob")

    @path_glob.setter
    def path_glob(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_glob", value)

    @_builtins.property
    @pulumi.getter(name="rulesTargets")
    def rules_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterRulesTargetArgs']]]]:
        return pulumi.get(self, "rules_targets")

    @rules_targets.setter
    def rules_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterRulesTargetArgs']]]]):
        pulumi.set(self, "rules_targets", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterScopeArgs']]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterScopeArgs']]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class _AppsecWafExclusionFilterState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_query: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_targets: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterRulesTargetArgs']]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterScopeArgs']]]] = None):
        """
        Input properties used for looking up and filtering AppsecWafExclusionFilter resources.
        :param pulumi.Input[_builtins.str] description: A description for the exclusion filter.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the exclusion filter is enabled.
        :param pulumi.Input[_builtins.str] event_query: The event query matched by the legacy exclusion filter. Cannot be created nor updated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_lists: The client IP addresses matched by the exclusion filter (CIDR notation is supported).
        :param pulumi.Input[_builtins.str] on_match: The action taken when the exclusion filter matches. When set to `monitor`, security traces are emitted but the requests are not blocked. By default, security traces are not emitted and the requests are not blocked.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] parameters: A list of parameters matched by the exclusion filter in the HTTP query string and HTTP request body. Nested parameters can be matched by joining fields with a dot character.
        :param pulumi.Input[_builtins.str] path_glob: The HTTP path glob expression matched by the exclusion filter.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_query is not None:
            pulumi.set(__self__, "event_query", event_query)
        if ip_lists is not None:
            pulumi.set(__self__, "ip_lists", ip_lists)
        if on_match is not None:
            pulumi.set(__self__, "on_match", on_match)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if path_glob is not None:
            pulumi.set(__self__, "path_glob", path_glob)
        if rules_targets is not None:
            pulumi.set(__self__, "rules_targets", rules_targets)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the exclusion filter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the exclusion filter is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="eventQuery")
    def event_query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The event query matched by the legacy exclusion filter. Cannot be created nor updated.
        """
        return pulumi.get(self, "event_query")

    @event_query.setter
    def event_query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_query", value)

    @_builtins.property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The client IP addresses matched by the exclusion filter (CIDR notation is supported).
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="onMatch")
    def on_match(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action taken when the exclusion filter matches. When set to `monitor`, security traces are emitted but the requests are not blocked. By default, security traces are not emitted and the requests are not blocked.
        """
        return pulumi.get(self, "on_match")

    @on_match.setter
    def on_match(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_match", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of parameters matched by the exclusion filter in the HTTP query string and HTTP request body. Nested parameters can be matched by joining fields with a dot character.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="pathGlob")
    def path_glob(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP path glob expression matched by the exclusion filter.
        """
        return pulumi.get(self, "path_glob")

    @path_glob.setter
    def path_glob(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_glob", value)

    @_builtins.property
    @pulumi.getter(name="rulesTargets")
    def rules_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterRulesTargetArgs']]]]:
        return pulumi.get(self, "rules_targets")

    @rules_targets.setter
    def rules_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterRulesTargetArgs']]]]):
        pulumi.set(self, "rules_targets", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterScopeArgs']]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafExclusionFilterScopeArgs']]]]):
        pulumi.set(self, "scopes", value)


@pulumi.type_token("datadog:index/appsecWafExclusionFilter:AppsecWafExclusionFilter")
class AppsecWafExclusionFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_query: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafExclusionFilterRulesTargetArgs', 'AppsecWafExclusionFilterRulesTargetArgsDict']]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafExclusionFilterScopeArgs', 'AppsecWafExclusionFilterScopeArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Datadog AppsecWafExclusionFilter resource. This can be used to create and manage Datadog appsec_waf_exclusion_filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a WAF exclusion filter on a path
        exclude_on_path = datadog.index.AppsecExclusionFilter("exclude_on_path",
            description=Exclude false positives on a path,
            enabled=True,
            path_glob=/accounts/*,
            rules_target=[{
                tags: [{
                    category: attack_attempt,
                    type: lfi,
                }],
            }],
            scope=[{
                env: www,
                service: prod,
            }])
        # Create a WAF exclusion filter for trusted IPs
        trusted_ips = datadog.index.AppsecExclusionFilter("trusted_ips",
            description=Do not block office IP network,
            enabled=True,
            ip_list=[198.10.14.53/24],
            on_match=monitor)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/appsecWafExclusionFilter:AppsecWafExclusionFilter passlist_entry "45b7032f-0ac4-4b2f-9118-363523c625f6"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the exclusion filter.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the exclusion filter is enabled.
        :param pulumi.Input[_builtins.str] event_query: The event query matched by the legacy exclusion filter. Cannot be created nor updated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_lists: The client IP addresses matched by the exclusion filter (CIDR notation is supported).
        :param pulumi.Input[_builtins.str] on_match: The action taken when the exclusion filter matches. When set to `monitor`, security traces are emitted but the requests are not blocked. By default, security traces are not emitted and the requests are not blocked.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] parameters: A list of parameters matched by the exclusion filter in the HTTP query string and HTTP request body. Nested parameters can be matched by joining fields with a dot character.
        :param pulumi.Input[_builtins.str] path_glob: The HTTP path glob expression matched by the exclusion filter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppsecWafExclusionFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog AppsecWafExclusionFilter resource. This can be used to create and manage Datadog appsec_waf_exclusion_filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a WAF exclusion filter on a path
        exclude_on_path = datadog.index.AppsecExclusionFilter("exclude_on_path",
            description=Exclude false positives on a path,
            enabled=True,
            path_glob=/accounts/*,
            rules_target=[{
                tags: [{
                    category: attack_attempt,
                    type: lfi,
                }],
            }],
            scope=[{
                env: www,
                service: prod,
            }])
        # Create a WAF exclusion filter for trusted IPs
        trusted_ips = datadog.index.AppsecExclusionFilter("trusted_ips",
            description=Do not block office IP network,
            enabled=True,
            ip_list=[198.10.14.53/24],
            on_match=monitor)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/appsecWafExclusionFilter:AppsecWafExclusionFilter passlist_entry "45b7032f-0ac4-4b2f-9118-363523c625f6"
        ```

        :param str resource_name: The name of the resource.
        :param AppsecWafExclusionFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppsecWafExclusionFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_query: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafExclusionFilterRulesTargetArgs', 'AppsecWafExclusionFilterRulesTargetArgsDict']]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafExclusionFilterScopeArgs', 'AppsecWafExclusionFilterScopeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppsecWafExclusionFilterArgs.__new__(AppsecWafExclusionFilterArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event_query"] = event_query
            __props__.__dict__["ip_lists"] = ip_lists
            __props__.__dict__["on_match"] = on_match
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["path_glob"] = path_glob
            __props__.__dict__["rules_targets"] = rules_targets
            __props__.__dict__["scopes"] = scopes
        super(AppsecWafExclusionFilter, __self__).__init__(
            'datadog:index/appsecWafExclusionFilter:AppsecWafExclusionFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            event_query: Optional[pulumi.Input[_builtins.str]] = None,
            ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            on_match: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            path_glob: Optional[pulumi.Input[_builtins.str]] = None,
            rules_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafExclusionFilterRulesTargetArgs', 'AppsecWafExclusionFilterRulesTargetArgsDict']]]]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafExclusionFilterScopeArgs', 'AppsecWafExclusionFilterScopeArgsDict']]]]] = None) -> 'AppsecWafExclusionFilter':
        """
        Get an existing AppsecWafExclusionFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the exclusion filter.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the exclusion filter is enabled.
        :param pulumi.Input[_builtins.str] event_query: The event query matched by the legacy exclusion filter. Cannot be created nor updated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_lists: The client IP addresses matched by the exclusion filter (CIDR notation is supported).
        :param pulumi.Input[_builtins.str] on_match: The action taken when the exclusion filter matches. When set to `monitor`, security traces are emitted but the requests are not blocked. By default, security traces are not emitted and the requests are not blocked.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] parameters: A list of parameters matched by the exclusion filter in the HTTP query string and HTTP request body. Nested parameters can be matched by joining fields with a dot character.
        :param pulumi.Input[_builtins.str] path_glob: The HTTP path glob expression matched by the exclusion filter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppsecWafExclusionFilterState.__new__(_AppsecWafExclusionFilterState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_query"] = event_query
        __props__.__dict__["ip_lists"] = ip_lists
        __props__.__dict__["on_match"] = on_match
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["path_glob"] = path_glob
        __props__.__dict__["rules_targets"] = rules_targets
        __props__.__dict__["scopes"] = scopes
        return AppsecWafExclusionFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description for the exclusion filter.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the exclusion filter is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="eventQuery")
    def event_query(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The event query matched by the legacy exclusion filter. Cannot be created nor updated.
        """
        return pulumi.get(self, "event_query")

    @_builtins.property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The client IP addresses matched by the exclusion filter (CIDR notation is supported).
        """
        return pulumi.get(self, "ip_lists")

    @_builtins.property
    @pulumi.getter(name="onMatch")
    def on_match(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The action taken when the exclusion filter matches. When set to `monitor`, security traces are emitted but the requests are not blocked. By default, security traces are not emitted and the requests are not blocked.
        """
        return pulumi.get(self, "on_match")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of parameters matched by the exclusion filter in the HTTP query string and HTTP request body. Nested parameters can be matched by joining fields with a dot character.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="pathGlob")
    def path_glob(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The HTTP path glob expression matched by the exclusion filter.
        """
        return pulumi.get(self, "path_glob")

    @_builtins.property
    @pulumi.getter(name="rulesTargets")
    def rules_targets(self) -> pulumi.Output[Optional[Sequence['outputs.AppsecWafExclusionFilterRulesTarget']]]:
        return pulumi.get(self, "rules_targets")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence['outputs.AppsecWafExclusionFilterScope']]]:
        return pulumi.get(self, "scopes")

