# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIntegrationExternalIdResult',
    'AwaitableGetIntegrationExternalIdResult',
    'get_integration_external_id',
    'get_integration_external_id_output',
]

@pulumi.output_type
class GetIntegrationExternalIdResult:
    """
    A collection of values returned by getIntegrationExternalId.
    """
    def __init__(__self__, aws_account_id=None, external_id=None, id=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> _builtins.str:
        """
        The AWS account ID of the integration to retrieve the external ID from. Must be a valid 12 digits AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The external ID associated with the AWS integration.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetIntegrationExternalIdResult(GetIntegrationExternalIdResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIntegrationExternalIdResult(
            aws_account_id=self.aws_account_id,
            external_id=self.external_id,
            id=self.id)


def get_integration_external_id(aws_account_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIntegrationExternalIdResult:
    """
    Use this data source to retrieve the external ID from an existing AWS integration. This can be used to reference the external ID value from an existing AWS account integration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    # Get the external ID for the AWS account "123456789012"
    example = datadog.aws.get_integration_external_id(aws_account_id="123456789012")
    ```


    :param _builtins.str aws_account_id: The AWS account ID of the integration to retrieve the external ID from. Must be a valid 12 digits AWS account ID.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:aws/getIntegrationExternalId:getIntegrationExternalId', __args__, opts=opts, typ=GetIntegrationExternalIdResult).value

    return AwaitableGetIntegrationExternalIdResult(
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        external_id=pulumi.get(__ret__, 'external_id'),
        id=pulumi.get(__ret__, 'id'))
def get_integration_external_id_output(aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIntegrationExternalIdResult]:
    """
    Use this data source to retrieve the external ID from an existing AWS integration. This can be used to reference the external ID value from an existing AWS account integration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    # Get the external ID for the AWS account "123456789012"
    example = datadog.aws.get_integration_external_id(aws_account_id="123456789012")
    ```


    :param _builtins.str aws_account_id: The AWS account ID of the integration to retrieve the external ID from. Must be a valid 12 digits AWS account ID.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:aws/getIntegrationExternalId:getIntegrationExternalId', __args__, opts=opts, typ=GetIntegrationExternalIdResult)
    return __ret__.apply(lambda __response__: GetIntegrationExternalIdResult(
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        external_id=pulumi.get(__response__, 'external_id'),
        id=pulumi.get(__response__, 'id')))
