# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsCurConfigArgs', 'AwsCurConfig']

@pulumi.input_type
class AwsCurConfigArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 bucket_name: pulumi.Input[_builtins.str],
                 report_name: pulumi.Input[_builtins.str],
                 report_prefix: pulumi.Input[_builtins.str],
                 account_filters: Optional[pulumi.Input['AwsCurConfigAccountFiltersArgs']] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AwsCurConfig resource.
        :param pulumi.Input[_builtins.str] account_id: The AWS account ID of your billing/payer account. For AWS Organizations, this is typically the management account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The S3 bucket name where your AWS Cost and Usage Report files are stored. This bucket must have appropriate IAM permissions for Datadog access and should be in the same AWS account as the CUR report.
        :param pulumi.Input[_builtins.str] report_name: The exact name of your AWS Cost and Usage Report as configured in AWS Billing preferences. This must match the report name exactly as it appears in your AWS billing settings.
        :param pulumi.Input[_builtins.str] report_prefix: The S3 key prefix where your Cost and Usage Report files are stored within the bucket (e.g., 'cur-reports/', 'billing/cur/').
        :param pulumi.Input[_builtins.str] bucket_region: The AWS region where the S3 bucket containing your Cost and Usage Report is located (e.g., us-east-1, eu-west-1).
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "report_name", report_name)
        pulumi.set(__self__, "report_prefix", report_prefix)
        if account_filters is not None:
            pulumi.set(__self__, "account_filters", account_filters)
        if bucket_region is not None:
            pulumi.set(__self__, "bucket_region", bucket_region)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The AWS account ID of your billing/payer account. For AWS Organizations, this is typically the management account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        The S3 bucket name where your AWS Cost and Usage Report files are stored. This bucket must have appropriate IAM permissions for Datadog access and should be in the same AWS account as the CUR report.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="reportName")
    def report_name(self) -> pulumi.Input[_builtins.str]:
        """
        The exact name of your AWS Cost and Usage Report as configured in AWS Billing preferences. This must match the report name exactly as it appears in your AWS billing settings.
        """
        return pulumi.get(self, "report_name")

    @report_name.setter
    def report_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "report_name", value)

    @_builtins.property
    @pulumi.getter(name="reportPrefix")
    def report_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The S3 key prefix where your Cost and Usage Report files are stored within the bucket (e.g., 'cur-reports/', 'billing/cur/').
        """
        return pulumi.get(self, "report_prefix")

    @report_prefix.setter
    def report_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "report_prefix", value)

    @_builtins.property
    @pulumi.getter(name="accountFilters")
    def account_filters(self) -> Optional[pulumi.Input['AwsCurConfigAccountFiltersArgs']]:
        return pulumi.get(self, "account_filters")

    @account_filters.setter
    def account_filters(self, value: Optional[pulumi.Input['AwsCurConfigAccountFiltersArgs']]):
        pulumi.set(self, "account_filters", value)

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region where the S3 bucket containing your Cost and Usage Report is located (e.g., us-east-1, eu-west-1).
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_region", value)


@pulumi.input_type
class _AwsCurConfigState:
    def __init__(__self__, *,
                 account_filters: Optional[pulumi.Input['AwsCurConfigAccountFiltersArgs']] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
                 report_name: Optional[pulumi.Input[_builtins.str]] = None,
                 report_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AwsCurConfig resources.
        :param pulumi.Input[_builtins.str] account_id: The AWS account ID of your billing/payer account. For AWS Organizations, this is typically the management account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The S3 bucket name where your AWS Cost and Usage Report files are stored. This bucket must have appropriate IAM permissions for Datadog access and should be in the same AWS account as the CUR report.
        :param pulumi.Input[_builtins.str] bucket_region: The AWS region where the S3 bucket containing your Cost and Usage Report is located (e.g., us-east-1, eu-west-1).
        :param pulumi.Input[_builtins.str] report_name: The exact name of your AWS Cost and Usage Report as configured in AWS Billing preferences. This must match the report name exactly as it appears in your AWS billing settings.
        :param pulumi.Input[_builtins.str] report_prefix: The S3 key prefix where your Cost and Usage Report files are stored within the bucket (e.g., 'cur-reports/', 'billing/cur/').
        """
        if account_filters is not None:
            pulumi.set(__self__, "account_filters", account_filters)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_region is not None:
            pulumi.set(__self__, "bucket_region", bucket_region)
        if report_name is not None:
            pulumi.set(__self__, "report_name", report_name)
        if report_prefix is not None:
            pulumi.set(__self__, "report_prefix", report_prefix)

    @_builtins.property
    @pulumi.getter(name="accountFilters")
    def account_filters(self) -> Optional[pulumi.Input['AwsCurConfigAccountFiltersArgs']]:
        return pulumi.get(self, "account_filters")

    @account_filters.setter
    def account_filters(self, value: Optional[pulumi.Input['AwsCurConfigAccountFiltersArgs']]):
        pulumi.set(self, "account_filters", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS account ID of your billing/payer account. For AWS Organizations, this is typically the management account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The S3 bucket name where your AWS Cost and Usage Report files are stored. This bucket must have appropriate IAM permissions for Datadog access and should be in the same AWS account as the CUR report.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region where the S3 bucket containing your Cost and Usage Report is located (e.g., us-east-1, eu-west-1).
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_region", value)

    @_builtins.property
    @pulumi.getter(name="reportName")
    def report_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The exact name of your AWS Cost and Usage Report as configured in AWS Billing preferences. This must match the report name exactly as it appears in your AWS billing settings.
        """
        return pulumi.get(self, "report_name")

    @report_name.setter
    def report_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "report_name", value)

    @_builtins.property
    @pulumi.getter(name="reportPrefix")
    def report_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The S3 key prefix where your Cost and Usage Report files are stored within the bucket (e.g., 'cur-reports/', 'billing/cur/').
        """
        return pulumi.get(self, "report_prefix")

    @report_prefix.setter
    def report_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "report_prefix", value)


@pulumi.type_token("datadog:index/awsCurConfig:AwsCurConfig")
class AwsCurConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_filters: Optional[pulumi.Input[Union['AwsCurConfigAccountFiltersArgs', 'AwsCurConfigAccountFiltersArgsDict']]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
                 report_name: Optional[pulumi.Input[_builtins.str]] = None,
                 report_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog AWS CUR (Cost and Usage Report) configuration resource. This enables Datadog Cloud Cost Management to access your AWS billing data by configuring the connection to your AWS Cost and Usage Report. **Prerequisites**: An active Datadog AWS integration, existing AWS Cost and Usage Report, and proper S3 bucket permissions.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/awsCurConfig:AwsCurConfig aws_cur_report <cloud_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The AWS account ID of your billing/payer account. For AWS Organizations, this is typically the management account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The S3 bucket name where your AWS Cost and Usage Report files are stored. This bucket must have appropriate IAM permissions for Datadog access and should be in the same AWS account as the CUR report.
        :param pulumi.Input[_builtins.str] bucket_region: The AWS region where the S3 bucket containing your Cost and Usage Report is located (e.g., us-east-1, eu-west-1).
        :param pulumi.Input[_builtins.str] report_name: The exact name of your AWS Cost and Usage Report as configured in AWS Billing preferences. This must match the report name exactly as it appears in your AWS billing settings.
        :param pulumi.Input[_builtins.str] report_prefix: The S3 key prefix where your Cost and Usage Report files are stored within the bucket (e.g., 'cur-reports/', 'billing/cur/').
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsCurConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog AWS CUR (Cost and Usage Report) configuration resource. This enables Datadog Cloud Cost Management to access your AWS billing data by configuring the connection to your AWS Cost and Usage Report. **Prerequisites**: An active Datadog AWS integration, existing AWS Cost and Usage Report, and proper S3 bucket permissions.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/awsCurConfig:AwsCurConfig aws_cur_report <cloud_account_id>
        ```

        :param str resource_name: The name of the resource.
        :param AwsCurConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsCurConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_filters: Optional[pulumi.Input[Union['AwsCurConfigAccountFiltersArgs', 'AwsCurConfigAccountFiltersArgsDict']]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
                 report_name: Optional[pulumi.Input[_builtins.str]] = None,
                 report_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsCurConfigArgs.__new__(AwsCurConfigArgs)

            __props__.__dict__["account_filters"] = account_filters
            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["bucket_region"] = bucket_region
            if report_name is None and not opts.urn:
                raise TypeError("Missing required property 'report_name'")
            __props__.__dict__["report_name"] = report_name
            if report_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'report_prefix'")
            __props__.__dict__["report_prefix"] = report_prefix
        super(AwsCurConfig, __self__).__init__(
            'datadog:index/awsCurConfig:AwsCurConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_filters: Optional[pulumi.Input[Union['AwsCurConfigAccountFiltersArgs', 'AwsCurConfigAccountFiltersArgsDict']]] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
            report_name: Optional[pulumi.Input[_builtins.str]] = None,
            report_prefix: Optional[pulumi.Input[_builtins.str]] = None) -> 'AwsCurConfig':
        """
        Get an existing AwsCurConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The AWS account ID of your billing/payer account. For AWS Organizations, this is typically the management account ID.
        :param pulumi.Input[_builtins.str] bucket_name: The S3 bucket name where your AWS Cost and Usage Report files are stored. This bucket must have appropriate IAM permissions for Datadog access and should be in the same AWS account as the CUR report.
        :param pulumi.Input[_builtins.str] bucket_region: The AWS region where the S3 bucket containing your Cost and Usage Report is located (e.g., us-east-1, eu-west-1).
        :param pulumi.Input[_builtins.str] report_name: The exact name of your AWS Cost and Usage Report as configured in AWS Billing preferences. This must match the report name exactly as it appears in your AWS billing settings.
        :param pulumi.Input[_builtins.str] report_prefix: The S3 key prefix where your Cost and Usage Report files are stored within the bucket (e.g., 'cur-reports/', 'billing/cur/').
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsCurConfigState.__new__(_AwsCurConfigState)

        __props__.__dict__["account_filters"] = account_filters
        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["bucket_region"] = bucket_region
        __props__.__dict__["report_name"] = report_name
        __props__.__dict__["report_prefix"] = report_prefix
        return AwsCurConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountFilters")
    def account_filters(self) -> pulumi.Output[Optional['outputs.AwsCurConfigAccountFilters']]:
        return pulumi.get(self, "account_filters")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS account ID of your billing/payer account. For AWS Organizations, this is typically the management account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        The S3 bucket name where your AWS Cost and Usage Report files are stored. This bucket must have appropriate IAM permissions for Datadog access and should be in the same AWS account as the CUR report.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS region where the S3 bucket containing your Cost and Usage Report is located (e.g., us-east-1, eu-west-1).
        """
        return pulumi.get(self, "bucket_region")

    @_builtins.property
    @pulumi.getter(name="reportName")
    def report_name(self) -> pulumi.Output[_builtins.str]:
        """
        The exact name of your AWS Cost and Usage Report as configured in AWS Billing preferences. This must match the report name exactly as it appears in your AWS billing settings.
        """
        return pulumi.get(self, "report_name")

    @_builtins.property
    @pulumi.getter(name="reportPrefix")
    def report_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The S3 key prefix where your Cost and Usage Report files are stored within the bucket (e.g., 'cur-reports/', 'billing/cur/').
        """
        return pulumi.get(self, "report_prefix")

