# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 client_email: pulumi.Input[_builtins.str],
                 client_id: pulumi.Input[_builtins.str],
                 private_key: pulumi.Input[_builtins.str],
                 private_key_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filters: Optional[pulumi.Input[_builtins.str]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 monitored_resource_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[_builtins.str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[_builtins.str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[_builtins.str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[_builtins.str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[_builtins.str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: List of filters to limit the Cloud Run revisions that are pulled into Datadog by using tags. Only Cloud Run revision resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] host_filters: List of filters to limit the VM instances that are pulled into Datadog by using tags. Only VM instance resources that apply to specified filters are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]] monitored_resource_configs: Configurations for GCP monitored resources. Only monitored resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "project_id", project_id)
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if cloud_run_revision_filters is not None:
            warnings.warn("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=cloud_run_revision`""", DeprecationWarning)
            pulumi.log.warn("""cloud_run_revision_filters is deprecated: **Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=cloud_run_revision`""")
        if cloud_run_revision_filters is not None:
            pulumi.set(__self__, "cloud_run_revision_filters", cloud_run_revision_filters)
        if cspm_resource_collection_enabled is not None:
            pulumi.set(__self__, "cspm_resource_collection_enabled", cspm_resource_collection_enabled)
        if host_filters is not None:
            warnings.warn("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=gce_instance`""", DeprecationWarning)
            pulumi.log.warn("""host_filters is deprecated: **Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=gce_instance`""")
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if is_resource_change_collection_enabled is not None:
            pulumi.set(__self__, "is_resource_change_collection_enabled", is_resource_change_collection_enabled)
        if is_security_command_center_enabled is not None:
            pulumi.set(__self__, "is_security_command_center_enabled", is_security_command_center_enabled)
        if monitored_resource_configs is not None:
            pulumi.set(__self__, "monitored_resource_configs", monitored_resource_configs)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Input[_builtins.str]:
        """
        Your email found in your JSON service account key.
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        Your ID found in your JSON service account key.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        Your private key name found in your JSON service account key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        Your private key ID found in your JSON service account key.
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Your Google Cloud project ID found in your JSON service account key.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automute", value)

    @_builtins.property
    @pulumi.getter(name="cloudRunRevisionFilters")
    @_utilities.deprecated("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=cloud_run_revision`""")
    def cloud_run_revision_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of filters to limit the Cloud Run revisions that are pulled into Datadog by using tags. Only Cloud Run revision resources that apply to specified filters are imported into Datadog.
        """
        return pulumi.get(self, "cloud_run_revision_filters")

    @cloud_run_revision_filters.setter
    def cloud_run_revision_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cloud_run_revision_filters", value)

    @_builtins.property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @cspm_resource_collection_enabled.setter
    def cspm_resource_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cspm_resource_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostFilters")
    @_utilities.deprecated("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=gce_instance`""")
    def host_filters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of filters to limit the VM instances that are pulled into Datadog by using tags. Only VM instance resources that apply to specified filters are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_filters", value)

    @_builtins.property
    @pulumi.getter(name="isResourceChangeCollectionEnabled")
    def is_resource_change_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        """
        return pulumi.get(self, "is_resource_change_collection_enabled")

    @is_resource_change_collection_enabled.setter
    def is_resource_change_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_resource_change_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @is_security_command_center_enabled.setter
    def is_security_command_center_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_security_command_center_enabled", value)

    @_builtins.property
    @pulumi.getter(name="monitoredResourceConfigs")
    def monitored_resource_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]]]:
        """
        Configurations for GCP monitored resources. Only monitored resources that apply to specified filters are imported into Datadog.
        """
        return pulumi.get(self, "monitored_resource_configs")

    @monitored_resource_configs.setter
    def monitored_resource_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]]]):
        pulumi.set(self, "monitored_resource_configs", value)

    @_builtins.property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resource_collection_enabled", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filters: Optional[pulumi.Input[_builtins.str]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 monitored_resource_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[_builtins.str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[_builtins.str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: List of filters to limit the Cloud Run revisions that are pulled into Datadog by using tags. Only Cloud Run revision resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] host_filters: List of filters to limit the VM instances that are pulled into Datadog by using tags. Only VM instance resources that apply to specified filters are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]] monitored_resource_configs: Configurations for GCP monitored resources. Only monitored resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[_builtins.str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[_builtins.str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if cloud_run_revision_filters is not None:
            warnings.warn("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=cloud_run_revision`""", DeprecationWarning)
            pulumi.log.warn("""cloud_run_revision_filters is deprecated: **Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=cloud_run_revision`""")
        if cloud_run_revision_filters is not None:
            pulumi.set(__self__, "cloud_run_revision_filters", cloud_run_revision_filters)
        if cspm_resource_collection_enabled is not None:
            pulumi.set(__self__, "cspm_resource_collection_enabled", cspm_resource_collection_enabled)
        if host_filters is not None:
            warnings.warn("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=gce_instance`""", DeprecationWarning)
            pulumi.log.warn("""host_filters is deprecated: **Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=gce_instance`""")
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if is_resource_change_collection_enabled is not None:
            pulumi.set(__self__, "is_resource_change_collection_enabled", is_resource_change_collection_enabled)
        if is_security_command_center_enabled is not None:
            pulumi.set(__self__, "is_security_command_center_enabled", is_security_command_center_enabled)
        if monitored_resource_configs is not None:
            pulumi.set(__self__, "monitored_resource_configs", monitored_resource_configs)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)

    @_builtins.property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automute", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your email found in your JSON service account key.
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your ID found in your JSON service account key.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudRunRevisionFilters")
    @_utilities.deprecated("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=cloud_run_revision`""")
    def cloud_run_revision_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of filters to limit the Cloud Run revisions that are pulled into Datadog by using tags. Only Cloud Run revision resources that apply to specified filters are imported into Datadog.
        """
        return pulumi.get(self, "cloud_run_revision_filters")

    @cloud_run_revision_filters.setter
    def cloud_run_revision_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cloud_run_revision_filters", value)

    @_builtins.property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @cspm_resource_collection_enabled.setter
    def cspm_resource_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cspm_resource_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostFilters")
    @_utilities.deprecated("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=gce_instance`""")
    def host_filters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of filters to limit the VM instances that are pulled into Datadog by using tags. Only VM instance resources that apply to specified filters are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_filters", value)

    @_builtins.property
    @pulumi.getter(name="isResourceChangeCollectionEnabled")
    def is_resource_change_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        """
        return pulumi.get(self, "is_resource_change_collection_enabled")

    @is_resource_change_collection_enabled.setter
    def is_resource_change_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_resource_change_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @is_security_command_center_enabled.setter
    def is_security_command_center_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_security_command_center_enabled", value)

    @_builtins.property
    @pulumi.getter(name="monitoredResourceConfigs")
    def monitored_resource_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]]]:
        """
        Configurations for GCP monitored resources. Only monitored resources that apply to specified filters are imported into Datadog.
        """
        return pulumi.get(self, "monitored_resource_configs")

    @monitored_resource_configs.setter
    def monitored_resource_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMonitoredResourceConfigArgs']]]]):
        pulumi.set(self, "monitored_resource_configs", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your private key name found in your JSON service account key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your private key ID found in your JSON service account key.
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your Google Cloud project ID found in your JSON service account key.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resource_collection_enabled", value)


@pulumi.type_token("datadog:gcp/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filters: Optional[pulumi.Input[_builtins.str]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 monitored_resource_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMonitoredResourceConfigArgs', 'IntegrationMonitoredResourceConfigArgsDict']]]]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource is deprecated—use the `gcp.IntegrationSts` resource instead. Provides a Datadog - Google Cloud Platform integration resource. This can be used to create and manage Datadog - Google Cloud Platform integration.

        ## Import

        The `pulumi import` command can be used, for example:

        Google Cloud Platform integrations can be imported using their project ID, e.g.

        ```sh
        $ pulumi import datadog:gcp/integration:Integration awesome_gcp_project_integration project_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[_builtins.str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[_builtins.str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: List of filters to limit the Cloud Run revisions that are pulled into Datadog by using tags. Only Cloud Run revision resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] host_filters: List of filters to limit the VM instances that are pulled into Datadog by using tags. Only VM instance resources that apply to specified filters are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMonitoredResourceConfigArgs', 'IntegrationMonitoredResourceConfigArgsDict']]]] monitored_resource_configs: Configurations for GCP monitored resources. Only monitored resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[_builtins.str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[_builtins.str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is deprecated—use the `gcp.IntegrationSts` resource instead. Provides a Datadog - Google Cloud Platform integration resource. This can be used to create and manage Datadog - Google Cloud Platform integration.

        ## Import

        The `pulumi import` command can be used, for example:

        Google Cloud Platform integrations can be imported using their project ID, e.g.

        ```sh
        $ pulumi import datadog:gcp/integration:Integration awesome_gcp_project_integration project_id
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cspm_resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_filters: Optional[pulumi.Input[_builtins.str]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 monitored_resource_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMonitoredResourceConfigArgs', 'IntegrationMonitoredResourceConfigArgsDict']]]]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["automute"] = automute
            if client_email is None and not opts.urn:
                raise TypeError("Missing required property 'client_email'")
            __props__.__dict__["client_email"] = client_email
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["cloud_run_revision_filters"] = cloud_run_revision_filters
            __props__.__dict__["cspm_resource_collection_enabled"] = cspm_resource_collection_enabled
            __props__.__dict__["host_filters"] = host_filters
            __props__.__dict__["is_resource_change_collection_enabled"] = is_resource_change_collection_enabled
            __props__.__dict__["is_security_command_center_enabled"] = is_security_command_center_enabled
            __props__.__dict__["monitored_resource_configs"] = monitored_resource_configs
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if private_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_key_id'")
            __props__.__dict__["private_key_id"] = private_key_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'datadog:gcp/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automute: Optional[pulumi.Input[_builtins.bool]] = None,
            client_email: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cspm_resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            host_filters: Optional[pulumi.Input[_builtins.str]] = None,
            is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            monitored_resource_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMonitoredResourceConfigArgs', 'IntegrationMonitoredResourceConfigArgsDict']]]]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        :param pulumi.Input[_builtins.str] client_email: Your email found in your JSON service account key.
        :param pulumi.Input[_builtins.str] client_id: Your ID found in your JSON service account key.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: List of filters to limit the Cloud Run revisions that are pulled into Datadog by using tags. Only Cloud Run revision resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.bool] cspm_resource_collection_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] host_filters: List of filters to limit the VM instances that are pulled into Datadog by using tags. Only VM instance resources that apply to specified filters are imported into Datadog. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMonitoredResourceConfigArgs', 'IntegrationMonitoredResourceConfigArgsDict']]]] monitored_resource_configs: Configurations for GCP monitored resources. Only monitored resources that apply to specified filters are imported into Datadog.
        :param pulumi.Input[_builtins.str] private_key: Your private key name found in your JSON service account key.
        :param pulumi.Input[_builtins.str] private_key_id: Your private key ID found in your JSON service account key.
        :param pulumi.Input[_builtins.str] project_id: Your Google Cloud project ID found in your JSON service account key.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["automute"] = automute
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["cloud_run_revision_filters"] = cloud_run_revision_filters
        __props__.__dict__["cspm_resource_collection_enabled"] = cspm_resource_collection_enabled
        __props__.__dict__["host_filters"] = host_filters
        __props__.__dict__["is_resource_change_collection_enabled"] = is_resource_change_collection_enabled
        __props__.__dict__["is_security_command_center_enabled"] = is_security_command_center_enabled
        __props__.__dict__["monitored_resource_configs"] = monitored_resource_configs
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_id"] = private_key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
        return Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def automute(self) -> pulumi.Output[_builtins.bool]:
        """
        Silence monitors for expected GCE instance shutdowns. Defaults to `false`.
        """
        return pulumi.get(self, "automute")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[_builtins.str]:
        """
        Your email found in your JSON service account key.
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        Your ID found in your JSON service account key.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="cloudRunRevisionFilters")
    @_utilities.deprecated("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=cloud_run_revision`""")
    def cloud_run_revision_filters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of filters to limit the Cloud Run revisions that are pulled into Datadog by using tags. Only Cloud Run revision resources that apply to specified filters are imported into Datadog.
        """
        return pulumi.get(self, "cloud_run_revision_filters")

    @_builtins.property
    @pulumi.getter(name="cspmResourceCollectionEnabled")
    def cspm_resource_collection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "cspm_resource_collection_enabled")

    @_builtins.property
    @pulumi.getter(name="hostFilters")
    @_utilities.deprecated("""**Note:** This field is deprecated. Instead, use `monitored_resource_configs` with `type=gce_instance`""")
    def host_filters(self) -> pulumi.Output[_builtins.str]:
        """
        List of filters to limit the VM instances that are pulled into Datadog by using tags. Only VM instance resources that apply to specified filters are imported into Datadog. Defaults to `""`.
        """
        return pulumi.get(self, "host_filters")

    @_builtins.property
    @pulumi.getter(name="isResourceChangeCollectionEnabled")
    def is_resource_change_collection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        """
        return pulumi.get(self, "is_resource_change_collection_enabled")

    @_builtins.property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @_builtins.property
    @pulumi.getter(name="monitoredResourceConfigs")
    def monitored_resource_configs(self) -> pulumi.Output[Sequence['outputs.IntegrationMonitoredResourceConfig']]:
        """
        Configurations for GCP monitored resources. Only monitored resources that apply to specified filters are imported into Datadog.
        """
        return pulumi.get(self, "monitored_resource_configs")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        Your private key name found in your JSON service account key.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        Your private key ID found in your JSON service account key.
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Your Google Cloud project ID found in your JSON service account key.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

