# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAppBuilderAppResult',
    'AwaitableGetAppBuilderAppResult',
    'get_app_builder_app',
    'get_app_builder_app_output',
]

@pulumi.output_type
class GetAppBuilderAppResult:
    """
    A collection of values returned by getAppBuilderApp.
    """
    def __init__(__self__, action_query_names_to_connection_ids=None, app_json=None, description=None, id=None, name=None, published=None, root_instance_name=None):
        if action_query_names_to_connection_ids and not isinstance(action_query_names_to_connection_ids, dict):
            raise TypeError("Expected argument 'action_query_names_to_connection_ids' to be a dict")
        pulumi.set(__self__, "action_query_names_to_connection_ids", action_query_names_to_connection_ids)
        if app_json and not isinstance(app_json, str):
            raise TypeError("Expected argument 'app_json' to be a str")
        pulumi.set(__self__, "app_json", app_json)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if published and not isinstance(published, bool):
            raise TypeError("Expected argument 'published' to be a bool")
        pulumi.set(__self__, "published", published)
        if root_instance_name and not isinstance(root_instance_name, str):
            raise TypeError("Expected argument 'root_instance_name' to be a str")
        pulumi.set(__self__, "root_instance_name", root_instance_name)

    @_builtins.property
    @pulumi.getter(name="actionQueryNamesToConnectionIds")
    def action_query_names_to_connection_ids(self) -> Mapping[str, _builtins.str]:
        """
        A map of the App's Action Query Names to Action Connection IDs.
        """
        return pulumi.get(self, "action_query_names_to_connection_ids")

    @_builtins.property
    @pulumi.getter(name="appJson")
    def app_json(self) -> _builtins.str:
        """
        The JSON representation of the App.
        """
        return pulumi.get(self, "app_json")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The human-readable description of the App.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID for the App.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def published(self) -> _builtins.bool:
        """
        Whether the app is published or unpublished. Published apps are available to other users. To ensure the app is accessible to the correct users, you also need to set a [Restriction Policy](https://docs.datadoghq.com/api/latest/restriction-policies/) on the app if a policy does not yet exist.
        """
        return pulumi.get(self, "published")

    @_builtins.property
    @pulumi.getter(name="rootInstanceName")
    def root_instance_name(self) -> _builtins.str:
        """
        The name of the root component of the app. This is a grid component that contains all other components.
        """
        return pulumi.get(self, "root_instance_name")


class AwaitableGetAppBuilderAppResult(GetAppBuilderAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppBuilderAppResult(
            action_query_names_to_connection_ids=self.action_query_names_to_connection_ids,
            app_json=self.app_json,
            description=self.description,
            id=self.id,
            name=self.name,
            published=self.published,
            root_instance_name=self.root_instance_name)


def get_app_builder_app(id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppBuilderAppResult:
    """
    This data source retrieves the definition of an existing Datadog App from App Builder for use in other resources, such as embedding Apps in Dashboards. This data source requires a registered application key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    my_app = datadog.get_app_builder_app(id="11111111-2222-3333-4444-555555555555")
    ```


    :param _builtins.str id: ID for the App.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getAppBuilderApp:getAppBuilderApp', __args__, opts=opts, typ=GetAppBuilderAppResult).value

    return AwaitableGetAppBuilderAppResult(
        action_query_names_to_connection_ids=pulumi.get(__ret__, 'action_query_names_to_connection_ids'),
        app_json=pulumi.get(__ret__, 'app_json'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        published=pulumi.get(__ret__, 'published'),
        root_instance_name=pulumi.get(__ret__, 'root_instance_name'))
def get_app_builder_app_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppBuilderAppResult]:
    """
    This data source retrieves the definition of an existing Datadog App from App Builder for use in other resources, such as embedding Apps in Dashboards. This data source requires a registered application key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    my_app = datadog.get_app_builder_app(id="11111111-2222-3333-4444-555555555555")
    ```


    :param _builtins.str id: ID for the App.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getAppBuilderApp:getAppBuilderApp', __args__, opts=opts, typ=GetAppBuilderAppResult)
    return __ret__.apply(lambda __response__: GetAppBuilderAppResult(
        action_query_names_to_connection_ids=pulumi.get(__response__, 'action_query_names_to_connection_ids'),
        app_json=pulumi.get(__response__, 'app_json'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        published=pulumi.get(__response__, 'published'),
        root_instance_name=pulumi.get(__response__, 'root_instance_name')))
